/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.mapreduce.example.kmeans;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import ml.shifu.guagua.mapreduce.example.kmeans.KMeansMasterParams;
import ml.shifu.guagua.mapreduce.example.kmeans.KMeansWorkerParams;
import ml.shifu.guagua.master.BasicMasterInterceptor;
import ml.shifu.guagua.master.MasterContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansCentriodsOutput
extends BasicMasterInterceptor<KMeansMasterParams, KMeansWorkerParams> {
    private static final Logger LOG = LoggerFactory.getLogger(KMeansCentriodsOutput.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postApplication(MasterContext<KMeansMasterParams, KMeansWorkerParams> context) {
        LOG.info("KMeansCentersOutput starts to write k centers to file.");
        Path out = new Path(context.getProps().getProperty("kmeans.centriods.output"));
        PrintWriter pw = null;
        try {
            FSDataOutputStream fos = FileSystem.get((Configuration)new Configuration()).create(out);
            LOG.info("Writing results to {}", (Object)out.toString());
            pw = new PrintWriter((OutputStream)fos);
            KMeansMasterParams masterResult = (KMeansMasterParams)context.getMasterResult();
            for (double[] center : masterResult.getPointList()) {
                pw.println(Arrays.toString(center));
            }
            pw.flush();
            IOUtils.closeStream((Closeable)pw);
        }
        catch (IOException e) {
            LOG.error("Error in writing output.", (Throwable)e);
        }
        finally {
            IOUtils.closeStream(pw);
        }
    }
}

