/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.mapreduce.example.sum;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import ml.shifu.guagua.hadoop.io.GuaguaWritableAdapter;
import ml.shifu.guagua.master.BasicMasterInterceptor;
import ml.shifu.guagua.master.MasterContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumOutput
extends BasicMasterInterceptor<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>> {
    private static final Logger LOG = LoggerFactory.getLogger(SumOutput.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postApplication(MasterContext<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>> context) {
        LOG.info("SumOutput starts to write final sum value to file.");
        Path out = new Path(context.getProps().getProperty("guagua.sum.output"));
        LOG.info("Writing results to {}", (Object)out.toString());
        PrintWriter pw = null;
        try {
            FSDataOutputStream fos = FileSystem.get((Configuration)new Configuration()).create(out);
            pw = new PrintWriter((OutputStream)fos);
            pw.println(((LongWritable)((GuaguaWritableAdapter)context.getMasterResult()).getWritable()).get());
            pw.flush();
            IOUtils.closeStream((Closeable)pw);
        }
        catch (IOException e) {
            LOG.error("Error in writing output.", (Throwable)e);
        }
        finally {
            IOUtils.closeStream(pw);
        }
    }
}

