/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.svm.training;

import org.encog.EncogError;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_problem;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;

public final class EncodeSVMProblem {
    public static svm_problem encode(MLDataSet training, int outputIndex) {
        try {
            svm_problem result = new svm_problem();
            result.l = (int)training.getRecordCount();
            result.y = new double[result.l];
            result.x = new svm_node[result.l][training.getInputSize()];
            int elementIndex = 0;
            for (MLDataPair pair : training) {
                MLData input = pair.getInput();
                MLData output = pair.getIdeal();
                result.x[elementIndex] = new svm_node[input.size()];
                for (int i = 0; i < input.size(); ++i) {
                    result.x[elementIndex][i] = new svm_node();
                    result.x[elementIndex][i].index = i + 1;
                    result.x[elementIndex][i].value = input.getData(i);
                }
                result.y[elementIndex] = output.getData(outputIndex);
                ++elementIndex;
            }
            return result;
        }
        catch (OutOfMemoryError e) {
            throw new EncogError("SVM Model - Out of Memory");
        }
    }

    private EncodeSVMProblem() {
    }
}

