/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.cpn;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.cpn.CPN;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;

public class PersistCPN
implements EncogPersistor {
    static final String PROPERTY_inputToInstar = "inputToInstar";
    static final String PROPERTY_instarToInput = "instarToInput";
    static final String PROPERTY_winnerCount = "winnerCount";

    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final String getPersistClassString() {
        return "CPN";
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        Map<String, String> networkParams = null;
        EncogReadHelper in = new EncogReadHelper(is);
        int inputCount = 0;
        int instarCount = 0;
        int outputCount = 0;
        int winnerCount = 0;
        Matrix m1 = null;
        Matrix m2 = null;
        while ((section = in.readNextSection()) != null) {
            if (section.getSectionName().equals("CPN") && section.getSubSectionName().equals("PARAMS")) {
                networkParams = section.parseParams();
            }
            if (!section.getSectionName().equals("CPN") || !section.getSubSectionName().equals("NETWORK")) continue;
            Map<String, String> params = section.parseParams();
            inputCount = EncogFileSection.parseInt(params, "inputCount");
            instarCount = EncogFileSection.parseInt(params, "instar");
            outputCount = EncogFileSection.parseInt(params, "outputCount");
            winnerCount = EncogFileSection.parseInt(params, PROPERTY_winnerCount);
            m1 = EncogFileSection.parseMatrix(params, PROPERTY_inputToInstar);
            m2 = EncogFileSection.parseMatrix(params, PROPERTY_instarToInput);
        }
        CPN result = new CPN(inputCount, instarCount, outputCount, winnerCount);
        result.getProperties().putAll(networkParams);
        result.getWeightsInputToInstar().set(m1);
        result.getWeightsInstarToOutstar().set(m2);
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        CPN cpn = (CPN)obj;
        out.addSection("CPN");
        out.addSubSection("PARAMS");
        out.addProperties(cpn.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("inputCount", cpn.getInputCount());
        out.writeProperty("instar", cpn.getInstarCount());
        out.writeProperty("outputCount", cpn.getOutputCount());
        out.writeProperty(PROPERTY_inputToInstar, cpn.getWeightsInputToInstar());
        out.writeProperty(PROPERTY_instarToInput, cpn.getWeightsInstarToOutstar());
        out.writeProperty(PROPERTY_winnerCount, cpn.getWinnerCount());
        out.flush();
    }
}

