/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.ComputableMonitor;
import ml.shifu.guagua.GuaguaConstants;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.GuaguaService;
import ml.shifu.guagua.InMemoryCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.HaltBytable;
import ml.shifu.guagua.io.Serializer;
import ml.shifu.guagua.master.LocalMasterCoordinator;
import ml.shifu.guagua.master.MasterComputable;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.master.MasterInterceptor;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.Progressable;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaMasterService<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
implements GuaguaService {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaMasterService.class);
    private Properties props;
    private List<MasterInterceptor<MASTER_RESULT, WORKER_RESULT>> masterInterceptors;
    private MasterComputable<MASTER_RESULT, WORKER_RESULT> masterComputable;
    private int totalIteration;
    private int workers;
    private String appId;
    private String containerId;
    private String masterResultClassName;
    private String workerResultClassName;
    private double minWorkersRatio;
    private long minWorkersTimeOut;
    private MasterContext<MASTER_RESULT, WORKER_RESULT> context;
    private InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator;
    private ExecutorService executor;
    private boolean isMonitored;
    private boolean isSoftForComputableTimeout = true;

    @Override
    public void start() {
        MasterContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        context.setCurrentIteration(0);
        for (MasterInterceptor<MASTER_RESULT, WORKER_RESULT> masterInterceptor : this.getMasterInterceptors()) {
            try {
                masterInterceptor.preApplication(context);
            }
            catch (Throwable e) {
                LOG.error("Error in master interceptors starting.", e);
                throw new GuaguaRuntimeException(e);
            }
        }
    }

    @Override
    public void run(Progressable progress) {
        int initialIteration;
        MasterContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        for (int i = initialIteration = context.getCurrentIteration(); i < this.getTotalIteration(); ++i) {
            int iteration = i + 1;
            context.setCurrentIteration(iteration);
            this.iterate(context, iteration, progress);
            MASTER_RESULT masterResult = context.getMasterResult();
            if (masterResult instanceof HaltBytable && ((HaltBytable)masterResult).isHalt()) break;
        }
    }

    protected MASTER_RESULT iterate(final MasterContext<MASTER_RESULT, WORKER_RESULT> context, int iteration, Progressable progress) {
        String status = "Start master iteration ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
        }
        for (MasterInterceptor<MASTER_RESULT, WORKER_RESULT> masterInterceptor : this.getMasterInterceptors()) {
            masterInterceptor.preIteration(context);
        }
        status = "Start master computing ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
        }
        Bytable masterResult = null;
        boolean isTimeOutInThread = false;
        if (this.isMonitored) {
            if (this.executor.isTerminated() || this.executor.isShutdown()) {
                this.executor = Executors.newSingleThreadExecutor();
            }
            ComputableMonitor monitor = this.masterComputable.getClass().getAnnotation(ComputableMonitor.class);
            TimeUnit unit = monitor.timeUnit();
            long duration = monitor.duration();
            try {
                masterResult = (Bytable)this.executor.submit(new Callable<MASTER_RESULT>(){

                    @Override
                    public MASTER_RESULT call() throws Exception {
                        return GuaguaMasterService.this.masterComputable.compute(context);
                    }
                }).get(duration, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.error("Error in master computation:", (Throwable)e);
                throw new GuaguaRuntimeException(e);
            }
            catch (TimeoutException e) {
                isTimeOutInThread = true;
                LOG.warn("Time out for master computation, null will be returned");
                this.executor.shutdownNow();
                masterResult = null;
            }
        } else {
            masterResult = (Bytable)this.masterComputable.compute(context);
        }
        context.setMasterResult(masterResult);
        status = "Complete master computing ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
        }
        int interceptorsSize = this.getMasterInterceptors().size();
        for (int i = 0; i < interceptorsSize; ++i) {
            this.getMasterInterceptors().get(interceptorsSize - 1 - i).postIteration(context);
        }
        status = "Complete master iteration ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), iteration * 100 / this.getTotalIteration()), true, false);
        }
        return (MASTER_RESULT)masterResult;
    }

    private MasterContext<MASTER_RESULT, WORKER_RESULT> buildContext() {
        if (this.getContext() != null) {
            return this.getContext();
        }
        this.context = new MasterContext(this.getTotalIteration(), this.getWorkers(), this.getProps(), this.getAppId(), this.getContainerId(), this.getMasterResultClassName(), this.getWorkerResultClassName(), this.getMinWorkersRatio(), this.getMinWorkersTimeOut());
        return this.getContext();
    }

    @Override
    public void stop() {
        if (this.isMonitored && this.executor != null) {
            this.executor.shutdown();
        }
        MasterContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        context.setCurrentIteration(context.getCurrentIteration() + 1);
        int interceptorsSize = this.getMasterInterceptors().size();
        Throwable exception = null;
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                this.getMasterInterceptors().get(interceptorsSize - 1 - i).postApplication(context);
                continue;
            }
            catch (Throwable e) {
                LOG.error("Error in master interceptors cleaning.", e);
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw new GuaguaRuntimeException(exception);
        }
    }

    @Override
    public void init(Properties props) {
        this.setProps(props);
        this.checkAndSetMasterInterceptors(props);
        this.setMasterComputable(this.newMasterComputable());
        this.isMonitored = this.getMasterComputable().getClass().isAnnotationPresent(ComputableMonitor.class);
        if (this.isMonitored) {
            this.isSoftForComputableTimeout = this.masterComputable.getClass().getAnnotation(ComputableMonitor.class).isSoft();
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.setTotalIteration(Integer.valueOf(this.getProps().getProperty("guagua.iteration.count", "2147483647")));
        this.setWorkers(Integer.valueOf(this.getProps().getProperty("guagua.worker.number")));
        this.setMasterResultClassName(this.getProps().getProperty("guagua.master.result.class"));
        this.setWorkerResultClassName(this.getProps().getProperty("guagua.worker.result.class"));
        double minWorkersRatio = NumberFormatUtils.getDouble(this.getProps().getProperty("guagua.min.workers.ratio"), 1.0);
        this.setMinWorkersRatio(minWorkersRatio);
        long minWorkersTimeOut = NumberFormatUtils.getLong(this.getProps().getProperty("guagua.min.workers.timeout"), 60000L);
        this.setMinWorkersTimeOut(minWorkersTimeOut);
    }

    private void checkAndSetMasterInterceptors(Properties props) {
        String masterInterceptorsStr;
        ArrayList<MasterInterceptor<MASTER_RESULT, WORKER_RESULT>> masterInterceptors = new ArrayList<MasterInterceptor<MASTER_RESULT, WORKER_RESULT>>();
        String systemMasterInterceptorsStr = StringUtils.get(props.getProperty("guagua.master.system.intercepters"), GuaguaConstants.GUAGUA_MASTER_DEFAULT_SYSTEM_INTERCEPTERS);
        if (systemMasterInterceptorsStr != null && systemMasterInterceptorsStr.length() != 0) {
            Object[] interceptors = systemMasterInterceptorsStr.split(",");
            if (LOG.isInfoEnabled()) {
                LOG.info("System master interceptors: {}.", (Object)Arrays.toString(interceptors));
            }
            for (Object interceptor : interceptors) {
                MasterInterceptor instance = (MasterInterceptor)ReflectionUtils.newInstance(((String)interceptor).trim());
                if (instance instanceof BasicCoordinator) {
                    String serialierClassName = StringUtils.get(props.getProperty("guagua.master.io.serializer"), "ml.shifu.guagua.io.BytableSerializer");
                    Serializer masterSerializer = (Serializer)ReflectionUtils.newInstance(serialierClassName);
                    ((BasicCoordinator)((Object)instance)).setMasterSerializer(masterSerializer);
                    serialierClassName = StringUtils.get(props.getProperty("guagua.worker.io.serializer"), "ml.shifu.guagua.io.BytableSerializer");
                    Serializer workerSerializer = (Serializer)ReflectionUtils.newInstance(serialierClassName);
                    ((BasicCoordinator)((Object)instance)).setWorkerSerializer(workerSerializer);
                } else if (instance instanceof LocalMasterCoordinator) {
                    ((LocalMasterCoordinator)instance).setCoordinator(this.coordinator);
                }
                masterInterceptors.add(instance);
            }
        }
        if ((masterInterceptorsStr = props.getProperty("guagua.master.intercepters")) != null && masterInterceptorsStr.length() != 0) {
            Object[] interceptors = masterInterceptorsStr.split(",");
            if (LOG.isInfoEnabled()) {
                LOG.info("Customized master interceptors: {}.", (Object)Arrays.toString(interceptors));
            }
            for (Object interceptor : interceptors) {
                MasterInterceptor instance = (MasterInterceptor)ReflectionUtils.newInstance(((String)interceptor).trim());
                masterInterceptors.add(instance);
            }
        }
        this.setMasterInterceptors(masterInterceptors);
    }

    private MasterComputable<MASTER_RESULT, WORKER_RESULT> newMasterComputable() {
        MasterComputable masterComputable;
        try {
            masterComputable = (MasterComputable)ReflectionUtils.newInstance(Class.forName(this.getProps().get("guagua.master.computable.class").toString()));
        }
        catch (ClassNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
        return masterComputable;
    }

    @Override
    public void setSplits(List<GuaguaFileSplit> splits) {
        throw new UnsupportedOperationException("Master doesn't need file splits.");
    }

    public String getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public MasterContext<MASTER_RESULT, WORKER_RESULT> getContext() {
        return this.context;
    }

    public MasterComputable<MASTER_RESULT, WORKER_RESULT> getMasterComputable() {
        return this.masterComputable;
    }

    public void setMasterComputable(MasterComputable<MASTER_RESULT, WORKER_RESULT> masterComputable) {
        this.masterComputable = masterComputable;
    }

    public List<MasterInterceptor<MASTER_RESULT, WORKER_RESULT>> getMasterInterceptors() {
        return this.masterInterceptors;
    }

    public void setMasterInterceptors(List<MasterInterceptor<MASTER_RESULT, WORKER_RESULT>> masterInterceptors) {
        this.masterInterceptors = masterInterceptors;
    }

    public void addMasterInterceptors(MasterInterceptor<MASTER_RESULT, WORKER_RESULT> masterInterceptor) {
        this.getMasterInterceptors().add(masterInterceptor);
    }

    public int getTotalIteration() {
        return this.totalIteration;
    }

    public void setTotalIteration(int totalIteration) {
        this.totalIteration = totalIteration;
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public String getMasterResultClassName() {
        return this.masterResultClassName;
    }

    public void setMasterResultClassName(String masterResultClassName) {
        this.masterResultClassName = masterResultClassName;
    }

    public String getWorkerResultClassName() {
        return this.workerResultClassName;
    }

    public void setWorkerResultClassName(String workerResultClassName) {
        this.workerResultClassName = workerResultClassName;
    }

    public double getMinWorkersRatio() {
        return this.minWorkersRatio;
    }

    public long getMinWorkersTimeOut() {
        return this.minWorkersTimeOut;
    }

    public void setMinWorkersRatio(double minWorkersRatio) {
        this.minWorkersRatio = minWorkersRatio;
    }

    public void setMinWorkersTimeOut(long minWorkersTimeOut) {
        this.minWorkersTimeOut = minWorkersTimeOut;
    }

    public InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> getCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator) {
        this.coordinator = coordinator;
    }
}

