/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.ComputableMonitor;
import ml.shifu.guagua.GuaguaConstants;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.GuaguaService;
import ml.shifu.guagua.InMemoryCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.HaltBytable;
import ml.shifu.guagua.io.Serializer;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.Progressable;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.util.StringUtils;
import ml.shifu.guagua.worker.LocalWorkerCoordinator;
import ml.shifu.guagua.worker.WorkerComputable;
import ml.shifu.guagua.worker.WorkerContext;
import ml.shifu.guagua.worker.WorkerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaWorkerService<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
implements GuaguaService {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaWorkerService.class);
    private Properties props;
    private WorkerComputable<MASTER_RESULT, WORKER_RESULT> workerComputable;
    private int totalIteration;
    private List<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> workerInterceptors;
    private List<GuaguaFileSplit> splits;
    private String appId;
    private String containerId;
    private String masterResultClassName;
    private String workerResultClassName;
    private WorkerContext<MASTER_RESULT, WORKER_RESULT> context;
    private InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator;
    private int overThresholdCount = 0;
    private static final int COUNT_THRESHOLD = 3;
    private int countThresholdDefined = 3;
    private ExecutorService executor;
    private boolean isMonitored;
    private boolean isSoftForComputableTimeout = true;

    @Override
    public void start() {
        WorkerContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        context.setCurrentIteration(0);
        for (WorkerInterceptor<MASTER_RESULT, WORKER_RESULT> workerInterceptor : this.getWorkerInterceptors()) {
            workerInterceptor.preApplication(context);
        }
    }

    @Override
    public void stop() {
        if (this.isMonitored && this.executor != null) {
            this.executor.shutdown();
        }
        WorkerContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        context.setCurrentIteration(context.getCurrentIteration() + 1);
        int interceptorsSize = this.getWorkerInterceptors().size();
        Throwable exception = null;
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                this.getWorkerInterceptors().get(interceptorsSize - 1 - i).postApplication(context);
                continue;
            }
            catch (Throwable e) {
                LOG.error("Error in worker interceptors cleaning.", e);
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw new GuaguaRuntimeException(exception);
        }
    }

    @Override
    public void run(Progressable progress) {
        WorkerContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        int firstIteration = context.getCurrentIteration() + 1;
        int iteration = context.getCurrentIteration();
        while (iteration < this.getTotalIteration()) {
            int currIter = iteration + 1;
            context.setCurrentIteration(currIter);
            this.iterate(context, firstIteration, progress);
            iteration = context.getCurrentIteration();
            MASTER_RESULT masterResult = context.getLastMasterResult();
            if (!(masterResult instanceof HaltBytable) || !((HaltBytable)masterResult).isHalt()) continue;
            break;
        }
    }

    protected WORKER_RESULT iterate(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context, int initialIteration, Progressable progress) {
        int iteration = context.getCurrentIteration();
        String status = "Start worker iteration ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
        }
        for (WorkerInterceptor<MASTER_RESULT, WORKER_RESULT> workerInterceptor : this.getWorkerInterceptors()) {
            workerInterceptor.preIteration(context);
        }
        status = "Start worker computing ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
        }
        long start = System.nanoTime();
        Bytable workerResult = null;
        boolean isKill = false;
        boolean isTimeOutInThread = false;
        try {
            if (this.isMonitored) {
                if (this.executor.isTerminated() || this.executor.isShutdown()) {
                    this.executor = Executors.newSingleThreadExecutor();
                }
                ComputableMonitor monitor = this.workerComputable.getClass().getAnnotation(ComputableMonitor.class);
                TimeUnit unit = monitor.timeUnit();
                long duration = monitor.duration();
                try {
                    workerResult = (Bytable)this.executor.submit(new Callable<WORKER_RESULT>(){

                        @Override
                        public WORKER_RESULT call() throws Exception {
                            return GuaguaWorkerService.this.workerComputable.compute(context);
                        }
                    }).get(duration, unit);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOG.error("Error in master computation:", (Throwable)e);
                    throw new GuaguaRuntimeException(e);
                }
                catch (TimeoutException e) {
                    isTimeOutInThread = true;
                    LOG.warn("Time out for master computation, null will be returned or mapper will be killed.");
                    this.executor.shutdownNow();
                    workerResult = null;
                }
            } else {
                workerResult = (Bytable)this.workerComputable.compute(context);
            }
            context.setWorkerResult(workerResult);
            long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long threashold = NumberFormatUtils.getLong(context.getProps().getProperty("guagua.computation.time.threshold"), 60000L);
            if (time >= threashold && iteration > initialIteration) {
                ++this.overThresholdCount;
                if (this.overThresholdCount >= this.countThresholdDefined) {
                    this.overThresholdCount = 0;
                    LOG.warn("Computation time is too long:{}, kill itself to make fail-over work.", (Object)time);
                    isKill = true;
                }
            }
            status = "Complete worker computing ( %s/%s ), progress %s%%";
            if (progress != null) {
                progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
            }
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException("Error in worker computation", e);
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException("Error in worker computation", e);
        }
        int interceptorsSize = this.getWorkerInterceptors().size();
        for (int i = 0; i < interceptorsSize; ++i) {
            this.getWorkerInterceptors().get(interceptorsSize - 1 - i).postIteration(context);
        }
        status = "Complete worker iteration ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), iteration * 100 / this.getTotalIteration()), true, isKill || isTimeOutInThread && !this.isSoftForComputableTimeout && !context.isFirstIteration());
        }
        return (WORKER_RESULT)workerResult;
    }

    private WorkerContext<MASTER_RESULT, WORKER_RESULT> buildContext() {
        if (this.getContext() != null) {
            return this.getContext();
        }
        this.context = new WorkerContext(this.getTotalIteration(), this.getAppId(), this.getProps(), this.getContainerId(), this.getSplits(), this.getMasterResultClassName(), this.getWorkerResultClassName());
        return this.getContext();
    }

    @Override
    public void init(Properties props) {
        this.setProps(props);
        this.checkAndSetWorkerInterceptors(props);
        this.setWorkerComputable(this.newWorkerComputable());
        this.isMonitored = this.getWorkerComputable().getClass().isAnnotationPresent(ComputableMonitor.class);
        if (this.isMonitored) {
            this.isSoftForComputableTimeout = this.workerComputable.getClass().getAnnotation(ComputableMonitor.class).isSoft();
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.countThresholdDefined = Integer.valueOf(this.getProps().getProperty("guagua.straggler.iterators", "3"));
        this.setTotalIteration(Integer.valueOf(this.getProps().getProperty("guagua.iteration.count", "2147483647")));
        this.setMasterResultClassName(this.getProps().getProperty("guagua.master.result.class"));
        this.setWorkerResultClassName(this.getProps().getProperty("guagua.worker.result.class"));
    }

    private void checkAndSetWorkerInterceptors(Properties props) {
        String workerInterceptorsStr;
        ArrayList<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> workerInterceptors = new ArrayList<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>>();
        String systemWorkerInterceptorsStr = StringUtils.get(props.getProperty("guagua.worker.system.intercepters"), GuaguaConstants.GUAGUA_WORKER_DEFAULT_SYSTEM_INTERCEPTERS);
        if (systemWorkerInterceptorsStr != null && systemWorkerInterceptorsStr.length() != 0) {
            Object[] interceptors = systemWorkerInterceptorsStr.split(",");
            if (LOG.isInfoEnabled()) {
                LOG.info("System worker interceptors: {}.", (Object)Arrays.toString(interceptors));
            }
            for (Object interceptor : interceptors) {
                WorkerInterceptor instance = (WorkerInterceptor)ReflectionUtils.newInstance(((String)interceptor).trim());
                if (instance instanceof BasicCoordinator) {
                    String serialierClassName = StringUtils.get(props.getProperty("guagua.master.io.serializer"), "ml.shifu.guagua.io.BytableSerializer");
                    Serializer masterSerializer = (Serializer)ReflectionUtils.newInstance(serialierClassName);
                    ((BasicCoordinator)((Object)instance)).setMasterSerializer(masterSerializer);
                    serialierClassName = StringUtils.get(props.getProperty("guagua.worker.io.serializer"), "ml.shifu.guagua.io.BytableSerializer");
                    Serializer workerSerializer = (Serializer)ReflectionUtils.newInstance(serialierClassName);
                    ((BasicCoordinator)((Object)instance)).setWorkerSerializer(workerSerializer);
                } else if (instance instanceof LocalWorkerCoordinator) {
                    ((LocalWorkerCoordinator)instance).setCoordinator(this.getCoordinator());
                }
                workerInterceptors.add(instance);
            }
        }
        if ((workerInterceptorsStr = props.getProperty("guagua.worker.intercepters")) != null && workerInterceptorsStr.length() != 0) {
            Object[] interceptors = workerInterceptorsStr.split(",");
            if (LOG.isInfoEnabled()) {
                LOG.info("Customized worker interceptors: {}.", (Object)Arrays.toString(interceptors));
            }
            for (Object interceptor : interceptors) {
                WorkerInterceptor instance = (WorkerInterceptor)ReflectionUtils.newInstance(((String)interceptor).trim());
                workerInterceptors.add(instance);
            }
        }
        this.setWorkerInterceptors(workerInterceptors);
    }

    private WorkerComputable<MASTER_RESULT, WORKER_RESULT> newWorkerComputable() {
        WorkerComputable workerComputable;
        try {
            workerComputable = (WorkerComputable)ReflectionUtils.newInstance(Class.forName(this.getProps().get("guagua.worker.computable.class").toString()));
        }
        catch (ClassNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
        return workerComputable;
    }

    private WorkerContext<MASTER_RESULT, WORKER_RESULT> getContext() {
        return this.context;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public List<GuaguaFileSplit> getSplits() {
        return this.splits;
    }

    @Override
    public void setSplits(List<GuaguaFileSplit> splits) {
        this.splits = splits;
    }

    public String getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public WorkerComputable<MASTER_RESULT, WORKER_RESULT> getWorkerComputable() {
        return this.workerComputable;
    }

    public void setWorkerComputable(WorkerComputable<MASTER_RESULT, WORKER_RESULT> workerComputable) {
        this.workerComputable = workerComputable;
    }

    public int getTotalIteration() {
        return this.totalIteration;
    }

    public void setTotalIteration(int totalIteration) {
        this.totalIteration = totalIteration;
    }

    public List<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> getWorkerInterceptors() {
        return this.workerInterceptors;
    }

    public void setWorkerInterceptors(List<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> workerInterceptors) {
        this.workerInterceptors = workerInterceptors;
    }

    public String getMasterResultClassName() {
        return this.masterResultClassName;
    }

    public void setMasterResultClassName(String masterResultClassName) {
        this.masterResultClassName = masterResultClassName;
    }

    public String getWorkerResultClassName() {
        return this.workerResultClassName;
    }

    public void setWorkerResultClassName(String workerResultClassName) {
        this.workerResultClassName = workerResultClassName;
    }

    public InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> getCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator) {
        this.coordinator = coordinator;
    }
}

