/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop.io;

import java.io.IOException;
import ml.shifu.guagua.hadoop.io.GuaguaWritableAdapter;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.GuaguaRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.SequenceFileAsBinaryInputFormat;

public class GuaguaSequenceAsBinaryRecordReader
implements GuaguaRecordReader<GuaguaWritableAdapter<BytesWritable>, GuaguaWritableAdapter<BytesWritable>> {
    private SequenceFileAsBinaryInputFormat.SequenceFileAsBinaryRecordReader sequenceReader;
    private Configuration conf;
    private GuaguaWritableAdapter<BytesWritable> key = null;
    private GuaguaWritableAdapter<BytesWritable> value = null;

    public GuaguaSequenceAsBinaryRecordReader() {
        this.conf = new Configuration();
    }

    public GuaguaSequenceAsBinaryRecordReader(GuaguaFileSplit split) throws IOException {
        this(new Configuration(), split);
    }

    public GuaguaSequenceAsBinaryRecordReader(Configuration conf, GuaguaFileSplit split) throws IOException {
        this.conf = conf;
        this.initialize(split);
    }

    public float getProgress() throws IOException {
        return this.sequenceReader.getProgress();
    }

    public void initialize(GuaguaFileSplit split) throws IOException {
        FileSplit fileSplit = new FileSplit(new Path(split.getPath()), split.getOffset(), split.getLength(), (String[])null);
        this.sequenceReader = new SequenceFileAsBinaryInputFormat.SequenceFileAsBinaryRecordReader(this.conf, fileSplit);
    }

    public boolean nextKeyValue() throws IOException {
        if (this.key == null) {
            this.key = new GuaguaWritableAdapter<BytesWritable>(new BytesWritable());
        }
        if (this.value == null) {
            this.value = new GuaguaWritableAdapter<BytesWritable>(new BytesWritable());
        }
        return this.sequenceReader.next(this.key.getWritable(), this.value.getWritable());
    }

    public GuaguaWritableAdapter<BytesWritable> getCurrentKey() {
        return this.key;
    }

    public GuaguaWritableAdapter<BytesWritable> getCurrentValue() {
        return this.value;
    }

    public synchronized void close() throws IOException {
        if (this.sequenceReader != null) {
            this.sequenceReader.close();
        }
    }
}

