/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import ml.shifu.guagua.io.HaltBytable;
import org.apache.hadoop.io.Writable;

public class GuaguaWritableAdapter<W extends Writable>
extends HaltBytable {
    private W writable;

    public GuaguaWritableAdapter(W writable) {
        this.writable = writable;
    }

    public void doWrite(DataOutput out) throws IOException {
        this.getWritable().write(out);
    }

    public void doReadFields(DataInput in) throws IOException {
        this.getWritable().readFields(in);
    }

    public W getWritable() {
        return this.writable;
    }

    public void setWritable(W writable) {
        this.writable = writable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isHalt() ? 1231 : 1237);
        result = 31 * result + (this.writable == null ? 0 : this.writable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GuaguaWritableAdapter other = (GuaguaWritableAdapter)((Object)obj);
        if (this.isHalt() != other.isHalt()) {
            return false;
        }
        return !(this.writable == null ? other.writable != null : !this.writable.equals(other.writable));
    }

    public String toString() {
        return String.format("GuaguaWritableAdapter [writable=%s, isHalt=%s]", this.getWritable(), super.isHalt());
    }
}

