/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.mapreduce;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GuaguaMRRecordReader
extends RecordReader<LongWritable, Text> {
    private static final LongWritable ONLY_KEY = new LongWritable(0L);
    private static final Text ONLY_VALUE = new Text("only value");
    private final int totalIterations;
    private static int currentIteration;

    public GuaguaMRRecordReader() {
        this(0);
    }

    public GuaguaMRRecordReader(int totalIterations) {
        this.totalIterations = totalIterations;
    }

    public void close() throws IOException {
    }

    public float getProgress() throws IOException {
        return (float)currentIteration * 1.0f / (float)this.totalIterations;
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return ONLY_KEY;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return ONLY_VALUE;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return currentIteration <= this.totalIterations;
    }

    public static void setCurrentIteration(int currentIteration) {
        GuaguaMRRecordReader.currentIteration = currentIteration;
    }
}

