/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.unit.GuaguaUnitDriver;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.hadoop.util.StringUtils;

public class GuaguaMRUnitDriver<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends GuaguaUnitDriver<MASTER_RESULT, WORKER_RESULT> {
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public GuaguaMRUnitDriver(Properties props) {
        super(props);
    }

    private boolean isPigOrHadoopMetaFile(Path path) {
        return path.toString().indexOf("_SUCCESS") >= 0 || path.toString().indexOf("pig_header") >= 0 || path.toString().indexOf("pig_schema") >= 0;
    }

    private boolean isSplitable(Configuration conf, Path file) {
        if (file.getName().endsWith("bz2")) {
            return true;
        }
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(file);
        return codec == null;
    }

    public List<GuaguaFileSplit[]> generateWorkerSplits(String inputs) throws IOException {
        ArrayList<GuaguaFileSplit[]> splits = new ArrayList<GuaguaFileSplit[]>();
        Configuration conf = new Configuration();
        List<FileStatus> files = this.listStatus(conf, inputs);
        for (FileStatus file : files) {
            Path path = file.getPath();
            if (this.isPigOrHadoopMetaFile(path)) continue;
            long length = file.getLen();
            if (length != 0L && this.isSplitable(conf, path)) {
                long splitSize = file.getBlockSize();
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    splits.add(new GuaguaFileSplit[]{new GuaguaFileSplit(path.toString(), length - bytesRemaining, splitSize)});
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                splits.add(new GuaguaFileSplit[]{new GuaguaFileSplit(path.toString(), length - bytesRemaining, bytesRemaining)});
                continue;
            }
            if (length == 0L) continue;
            splits.add(new GuaguaFileSplit[]{new GuaguaFileSplit(path.toString(), 0L, length)});
        }
        return splits;
    }

    private static Path[] getInputPaths(String inputs) {
        String[] list = StringUtils.split((String)inputs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    protected List<FileStatus> listStatus(Configuration conf, String input) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        Path[] dirs = GuaguaMRUnitDriver.getInputPaths(input);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<IOException> errors = new ArrayList<IOException>();
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(hiddenFileFilter);
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        for (int i = 0; i < dirs.length; ++i) {
            Path p = dirs[i];
            FileSystem fs = p.getFileSystem(conf);
            FileStatus[] matches = fs.globStatus(p, (PathFilter)inputFilter);
            if (matches == null) {
                errors.add(new IOException("Input path does not exist: " + p));
                continue;
            }
            if (matches.length == 0) {
                errors.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (FileStatus globStat : matches) {
                if (globStat.isDir()) {
                    for (FileStatus stat : fs.listStatus(globStat.getPath(), (PathFilter)inputFilter)) {
                        result.add(stat);
                    }
                    continue;
                }
                result.add(globStat);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        return result;
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (filter.accept(path)) continue;
                return false;
            }
            return true;
        }
    }
}

