/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.mapreduce;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ml.shifu.guagua.coordinator.zk.ZooKeeperUtils;
import ml.shifu.guagua.hadoop.io.GuaguaOptionsParser;
import ml.shifu.guagua.hadoop.io.GuaguaWritableSerializer;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.HaltBytable;
import ml.shifu.guagua.mapreduce.GuaguaInputFormat;
import ml.shifu.guagua.mapreduce.GuaguaMapper;
import ml.shifu.guagua.mapreduce.GuaguaOutputFormat;
import ml.shifu.guagua.master.MasterComputable;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.worker.WorkerComputable;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaMapReduceClient {
    private static final Logger LOG;
    private static final String INIT_JOB_ID_PREFIX = "Guagua-MapReduce-";
    private static String embededZooKeeperServer;
    private JobControl jc = new JobControl("Guagua-MapReduce-");

    public synchronized void addJob(String[] args) throws IOException {
        this.jc.addJob(new ControlledJob(this.createJob(args), null));
    }

    public void run() throws IOException {
        List jobsWithoutIds = this.jc.getWaitingJobList();
        int totalMRJobs = jobsWithoutIds.size();
        LOG.info("{} map-reduce job(s) waiting for submission.", (Object)jobsWithoutIds.size());
        Thread jcThread = new Thread((Runnable)this.jc, "Guagua-MapReduce-JobControl");
        jcThread.start();
        JobClient jobClient = new JobClient(new JobConf(new Configuration()));
        double lastProg = -1.0;
        HashSet<String> sucessfulJobs = new HashSet<String>();
        while (!this.jc.allFinished()) {
            try {
                jcThread.join(1000L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            ArrayList<ControlledJob> jobsAssignedIdInThisRun = new ArrayList<ControlledJob>(totalMRJobs);
            for (ControlledJob job : jobsWithoutIds) {
                if (job.getJob().getJobID() == null) continue;
                jobsAssignedIdInThisRun.add(job);
                LOG.info("Job {} is started.", (Object)job.getJob().getJobID().toString());
            }
            jobsWithoutIds.removeAll(jobsAssignedIdInThisRun);
            List successfulJobs = this.jc.getSuccessfulJobList();
            for (ControlledJob controlledJob : successfulJobs) {
                String jobId = controlledJob.getJob().getJobID().toString();
                if (sucessfulJobs.contains(jobId)) continue;
                LOG.info("Job {} is successful.", (Object)jobId);
                sucessfulJobs.add(jobId);
            }
            double prog = this.calculateProgress(this.jc, jobClient) / (double)totalMRJobs;
            this.notifyProgress(prog, lastProg);
            lastProg = prog;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        List successfulJobs = this.jc.getSuccessfulJobList();
        LOG.info("Sucessful jobs:");
        for (ControlledJob controlledJob : successfulJobs) {
            LOG.info("Job: {} ", (Object)controlledJob);
        }
        if (totalMRJobs == successfulJobs.size()) {
            LOG.info("Guagua jobs: 100% complete");
        } else {
            List failedJobs = this.jc.getFailedJobList();
            if (failedJobs.size() > 0) {
                LOG.info("Failed jobs:");
                for (ControlledJob controlledJob : failedJobs) {
                    LOG.warn("Job: {} ", (Object)controlledJob);
                }
            }
        }
        this.jc.stop();
    }

    private void notifyProgress(double prog, double lastProg) {
        int perCom;
        if (prog >= lastProg + 0.01 && (perCom = (int)(prog * 100.0)) != 100) {
            LOG.info("Guagua jobs: {}% complete", (Object)perCom);
        }
    }

    protected double calculateProgress(JobControl jc, JobClient jobClient) throws IOException {
        double prog = 0.0;
        prog += (double)jc.getSuccessfulJobList().size();
        List runnJobs = jc.getRunningJobList();
        for (ControlledJob cjob : runnJobs) {
            prog += this.progressOfRunningJob(cjob, jobClient);
        }
        return prog;
    }

    protected double progressOfRunningJob(ControlledJob cjob, JobClient jobClient) throws IOException {
        RunningJob rj = jobClient.getJob(cjob.getJob().getJobID().toString());
        if (rj == null && cjob.getJobState() == ControlledJob.State.SUCCESS) {
            return 1.0;
        }
        if (rj == null) {
            return 0.0;
        }
        return rj.mapProgress();
    }

    public static void addInputPath(Configuration conf, Path path) throws IOException {
        path = path.getFileSystem(conf).makeQualified(path);
        String dirStr = StringUtils.escapeString((String)path.toString());
        String dirs = conf.get("mapred.input.dir");
        conf.set("mapred.input.dir", dirs == null ? dirStr : dirs + "," + dirStr);
    }

    public synchronized Job createJob(String[] args) throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("mapred.task.timeout", conf.getInt("mapred.task.timeout", 1200000));
        GuaguaOptionsParser parser = new GuaguaOptionsParser(conf, args);
        CommandLine cmdLine = parser.getCommandLine();
        GuaguaMapReduceClient.checkInputSetting(conf, cmdLine);
        GuaguaMapReduceClient.checkZkServerSetting(conf, cmdLine);
        GuaguaMapReduceClient.checkWorkerClassSetting(conf, cmdLine);
        GuaguaMapReduceClient.checkMasterClassSetting(conf, cmdLine);
        GuaguaMapReduceClient.checkIterationCountSetting(conf, cmdLine);
        GuaguaMapReduceClient.checkResultClassSetting(conf, cmdLine);
        String name = GuaguaMapReduceClient.checkMapReduceNameSetting(cmdLine);
        Class<? extends InputFormat> inputFormatClass = GuaguaMapReduceClient.checkInputFormatSetting(cmdLine);
        conf.setBoolean("mapred.map.tasks.speculative.execution", false);
        conf.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        conf.setInt("mapreduce.job.max.split.locations", conf.getInt("mapreduce.job.max.split.locations", 100));
        conf.setInt("io.sort.mb", 0);
        conf.setInt("mapreduce.job.counters.limit", conf.getInt("mapreduce.job.counters.limit", 512));
        conf.setInt("mapred.job.reduce.memory.mb", 0);
        String childJavaOpts = conf.get("mapred.child.java.opts", "");
        if (childJavaOpts == null || childJavaOpts.length() == 0) {
            conf.set("mapred.child.java.opts", "-server -XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70");
        } else {
            String newChildJavaOpts = "-server -XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70 " + childJavaOpts;
            conf.set("mapred.child.java.opts", newChildJavaOpts.trim());
        }
        Job job = new Job(conf, name);
        job.setJarByClass(GuaguaMapReduceClient.class);
        job.setMapperClass(GuaguaMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setInputFormatClass(inputFormatClass);
        job.setOutputFormatClass(GuaguaOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    private static Class<? extends InputFormat> checkInputFormatSetting(CommandLine cmdLine) {
        Class inputFormatClass = GuaguaInputFormat.class;
        if (cmdLine.hasOption("-inputformat")) {
            String inputFormatClassName = cmdLine.getOptionValue("inputformat");
            try {
                inputFormatClass = Class.forName(inputFormatClassName.trim());
            }
            catch (ClassNotFoundException e) {
                GuaguaMapReduceClient.printUsage();
                throw new IllegalArgumentException(String.format("The inputformat class %s set by '-inputformat' can not be found in class path.", inputFormatClassName.trim()), e);
            }
            catch (ClassCastException e) {
                GuaguaMapReduceClient.printUsage();
                throw new IllegalArgumentException("Mapreduce input format class set by 'inputformat' should extend 'org.apache.hadoop.mapreduce.InputFormat' class.");
            }
        }
        return inputFormatClass;
    }

    private static String checkMapReduceNameSetting(CommandLine cmdLine) {
        String name = "Guagua Master-Workers Job";
        if (cmdLine.hasOption("-n")) {
            name = cmdLine.getOptionValue("n");
        }
        return name;
    }

    private static void checkResultClassSetting(Configuration conf, CommandLine cmdLine) {
        Class<?> workerResultClass;
        Class<?> masterResultClass;
        if (!cmdLine.hasOption("-mr")) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Master result class name should be provided by '-mr' parameter.");
        }
        String resultClassName = cmdLine.getOptionValue("mr").trim();
        try {
            masterResultClass = Class.forName(resultClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Master result class %s set by '-mr' can not be found in class path.", resultClassName), e);
        }
        if (Writable.class.isAssignableFrom(masterResultClass)) {
            conf.set("guagua.master.io.serializer", GuaguaWritableSerializer.class.getName());
            conf.set("guagua.master.result.class", resultClassName);
        } else if (Bytable.class.isAssignableFrom(masterResultClass)) {
            conf.set("guagua.master.result.class", resultClassName);
            if (!ReflectionUtils.hasEmptyParameterConstructor(masterResultClass)) {
                throw new IllegalArgumentException("Master result class should have default constuctor without any parameters.");
            }
        } else {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Master result class name provided by '-mr' parameter should implement 'com.paypal.guagua.io.Bytable' or 'org.apache.hadoop.io.Writable'.");
        }
        if (!cmdLine.hasOption("-wr")) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Worker result class name should be provided by '-wr' parameter.");
        }
        String resultClassName2 = cmdLine.getOptionValue("wr").trim();
        try {
            workerResultClass = Class.forName(resultClassName2);
        }
        catch (ClassNotFoundException e) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException(String.format("Worker result class %s set by '-wr' can not be found in class path.", resultClassName2), e);
        }
        if (Writable.class.isAssignableFrom(workerResultClass)) {
            conf.set("guagua.worker.io.serializer", GuaguaWritableSerializer.class.getName());
            conf.set("guagua.worker.result.class", resultClassName2);
        } else if (Bytable.class.isAssignableFrom(workerResultClass)) {
            conf.set("guagua.worker.result.class", resultClassName2);
            if (!ReflectionUtils.hasEmptyParameterConstructor(workerResultClass)) {
                throw new IllegalArgumentException("Worker result class should have default constuctor without any parameters.");
            }
        } else {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Worker result class name provided by '-wr' parameter should implement 'com.paypal.guagua.io.Bytable' or 'org.apache.hadoop.io.Writable'.");
        }
        if (HaltBytable.class.isAssignableFrom(masterResultClass) && !HaltBytable.class.isAssignableFrom(workerResultClass) || HaltBytable.class.isAssignableFrom(workerResultClass) && !HaltBytable.class.isAssignableFrom(masterResultClass)) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Worker and master result classes should both implementent HaltBytable.");
        }
    }

    private static void checkIterationCountSetting(Configuration conf, CommandLine cmdLine) {
        if (!cmdLine.hasOption("-c")) {
            System.err.println("WARN: Total iteration number is not set, default 50 will be used.");
            System.err.println("WARN: Total iteration number can be provided by '-c' parameter with non-empty value.");
            conf.setInt("guagua.iteration.count", 50);
        } else {
            int totalIteration = 0;
            try {
                totalIteration = Integer.parseInt(cmdLine.getOptionValue("c").trim());
            }
            catch (NumberFormatException e) {
                GuaguaMapReduceClient.printUsage();
                throw new IllegalArgumentException("Total iteration number set by '-c' should be a valid number.");
            }
            conf.setInt("guagua.iteration.count", totalIteration);
        }
    }

    private static void checkMasterClassSetting(Configuration conf, CommandLine cmdLine) {
        Class<?> masterClass;
        if (!cmdLine.hasOption("-m")) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Master class name should be provided by '-m' parameter.");
        }
        String masterClassOptionValue = cmdLine.getOptionValue("m");
        if (masterClassOptionValue == null || masterClassOptionValue.length() == 0) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Master class name should be provided by '-m' parameter with non-empty value.");
        }
        try {
            masterClass = Class.forName(masterClassOptionValue.trim());
        }
        catch (ClassNotFoundException e) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException(String.format("The master class %s set by '-m' can not be found in class path.", masterClassOptionValue.trim()), e);
        }
        if (!MasterComputable.class.isAssignableFrom(masterClass)) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Master class name provided by '-m' should implement 'com.paypal.guagua.master.MasterComputable' interface.");
        }
        if (!ReflectionUtils.hasEmptyParameterConstructor(masterClass)) {
            throw new IllegalArgumentException("Master class should have default constuctor without any parameters.");
        }
        conf.set("guagua.master.computable.class", masterClassOptionValue.trim());
    }

    private static void checkWorkerClassSetting(Configuration conf, CommandLine cmdLine) {
        Class<?> workerClass;
        if (!cmdLine.hasOption("-w")) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Worker class name should be provided by '-w' parameter.");
        }
        String workerClassOptionValue = cmdLine.getOptionValue("w");
        if (workerClassOptionValue == null || workerClassOptionValue.length() == 0) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Worker class name should be provided by '-w' parameter with non-empty value.");
        }
        try {
            workerClass = Class.forName(workerClassOptionValue.trim());
        }
        catch (ClassNotFoundException e) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException(String.format("The worker class %s set by '-w' can not be found in class path.", workerClassOptionValue.trim()), e);
        }
        if (!WorkerComputable.class.isAssignableFrom(workerClass)) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Worker class name provided by '-w' should implement 'com.paypal.guagua.worker.WorkerComputable' interface.");
        }
        if (!ReflectionUtils.hasEmptyParameterConstructor(workerClass)) {
            throw new IllegalArgumentException("Worker class should have default constuctor without any parameters.");
        }
        conf.set("guagua.worker.computable.class", workerClassOptionValue.trim());
    }

    private static void printUsage() {
        GuaguaOptionsParser.printGenericCommandUsage(System.out);
        System.out.println("For detailed invalid parameter, please check:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkZkServerSetting(Configuration conf, CommandLine cmdLine) {
        if (!cmdLine.hasOption("-z")) {
            System.err.println("WARN: ZooKeeper server is not set, embeded ZooKeeper server will be started.");
            System.err.println("WARN: For big data guagua application, independent ZooKeeper instance is recommended.");
            System.err.println("WARN: Zookeeper servers can be provided by '-z' parameter with non-empty value.");
            boolean isZkInClient = conf.getBoolean("guagua.zk.embedbed.isInClient", false);
            if (isZkInClient) {
                Class<GuaguaMapReduceClient> clazz = GuaguaMapReduceClient.class;
                synchronized (GuaguaMapReduceClient.class) {
                    if (embededZooKeeperServer == null) {
                        int embedZkClientPort = 0;
                        try {
                            embedZkClientPort = ZooKeeperUtils.startEmbedZooKeeper();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        ZooKeeperUtils.checkIfEmbedZooKeeperStarted((int)embedZkClientPort);
                        try {
                            embededZooKeeperServer = InetAddress.getLocalHost().getHostName() + ":" + embedZkClientPort;
                        }
                        catch (UnknownHostException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    conf.set("guagua.zk.servers", embededZooKeeperServer);
                }
            } else {
                conf.set("guagua.master.system.intercepters", conf.get("guagua.master.system.intercepters", "ml.shifu.guagua.master.MasterTimer,ml.shifu.guagua.master.MemoryStatsMasterInterceptor,ml.shifu.guagua.hadoop.ZooKeeperMasterInterceptor,ml.shifu.guagua.master.NettyMasterCoordinator "));
                conf.set("guagua.worker.system.intercepters", conf.get("guagua.worker.system.intercepters", "ml.shifu.guagua.worker.WorkerTimer,ml.shifu.guagua.worker.MemoryStatsWorkerInterceptor,ml.shifu.guagua.hadoop.ZooKeeperWorkerInterceptor,ml.shifu.guagua.worker.NettyWorkerCoordinator"));
                System.err.println("WARN: Zookeeper server will be started in master node of cluster");
            }
            return;
        }
        String zkServers = cmdLine.getOptionValue("z");
        if (zkServers == null || zkServers.length() == 0) {
            throw new IllegalArgumentException("Zookeeper servers should be provided by '-z' parameter with non-empty value.");
        }
        if (!ZooKeeperUtils.checkServers((String)zkServers)) {
            throw new RuntimeException("Your specifed zookeeper instance is not alive, please check.");
        }
        conf.set("guagua.zk.servers", zkServers.trim());
    }

    private static void checkInputSetting(Configuration conf, CommandLine cmdLine) throws IOException {
        if (!cmdLine.hasOption("-i")) {
            GuaguaMapReduceClient.printUsage();
            throw new IllegalArgumentException("Input should be provided by '-i' parameter.");
        }
        GuaguaMapReduceClient.addInputPath(conf, new Path(cmdLine.getOptionValue("i").trim()));
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        if (args.length == 0 || args.length == 1 && (args[0].equals("h") || args[0].equals("-h") || args[0].equals("-help") || args[0].equals("help"))) {
            GuaguaOptionsParser.printGenericCommandUsage(System.out);
            System.exit(0);
        }
        GuaguaMapReduceClient client = new GuaguaMapReduceClient();
        Job job = client.createJob(args);
        job.waitForCompletion(true);
    }

    static {
        Configuration.addDefaultResource((String)"guagua-site.xml");
        LOG = LoggerFactory.getLogger(GuaguaMapReduceClient.class);
        embededZooKeeperServer = null;
    }
}

