/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.mapreduce;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.GuaguaService;
import ml.shifu.guagua.hadoop.io.GuaguaInputSplit;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.mapreduce.GuaguaMRRecordReader;
import ml.shifu.guagua.master.GuaguaMasterService;
import ml.shifu.guagua.util.Progressable;
import ml.shifu.guagua.worker.GuaguaWorkerService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaMapper<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends Mapper<LongWritable, Text, Text, Text> {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaMapper.class);
    private boolean isMaster;
    private GuaguaService guaguaService;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        GuaguaInputSplit inputSplit = (GuaguaInputSplit)context.getInputSplit();
        this.setMaster(inputSplit.isMaster());
        if (this.isMaster()) {
            context.setStatus("Master initializing ...");
            this.setGuaguaService((GuaguaService)new GuaguaMasterService());
        } else {
            context.setStatus("Worker initializing ...");
            this.setGuaguaService((GuaguaService)new GuaguaWorkerService());
            LinkedList<GuaguaFileSplit> splits = new LinkedList<GuaguaFileSplit>();
            for (FileSplit fs : inputSplit.getFileSplits()) {
                splits.add(new GuaguaFileSplit(fs.getPath().toString(), fs.getStart(), fs.getLength()));
            }
            this.getGuaguaService().setSplits(splits);
        }
        Properties props = this.replaceConfToProps(context.getConfiguration());
        this.getGuaguaService().setAppId(context.getConfiguration().get("mapred.job.id"));
        this.getGuaguaService().setContainerId(context.getConfiguration().get("mapred.task.partition"));
        this.getGuaguaService().init(props);
        this.getGuaguaService().start();
    }

    private Properties replaceConfToProps(Configuration configuration) {
        Properties properties = new Properties();
        for (Map.Entry entry : configuration) {
            properties.put(entry.getKey(), entry.getValue());
            if (!LOG.isDebugEnabled() || !((String)entry.getKey()).startsWith("guagua")) continue;
            LOG.debug("{}:{}", entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public void run(final Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.setup(context);
            final int iterations = context.getConfiguration().getInt("guagua.iteration.count", -1);
            this.getGuaguaService().run(new Progressable(){

                public void progress(int iteration, int totalIteration, String status, boolean isLastUpdate, boolean isKill) {
                    if (isKill) {
                        GuaguaMapper.this.failTask(null, context.getConfiguration());
                        return;
                    }
                    context.progress();
                    GuaguaMRRecordReader.setCurrentIteration(iteration);
                    try {
                        context.nextKeyValue();
                    }
                    catch (IOException e) {
                        throw new GuaguaRuntimeException((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (isLastUpdate) {
                        LOG.info("Application progress: {}%.", (Object)(iteration * 100 / iterations));
                    }
                    if (status != null && status.length() != 0) {
                        context.setStatus(status);
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.error("Error in guagua main run method.", t);
            this.failTask(t, context.getConfiguration());
            throw new GuaguaRuntimeException(t);
        }
        finally {
            try {
                this.cleanup(context);
            }
            catch (Throwable t) {
                this.failTask(t, context.getConfiguration());
            }
        }
    }

    private void failTask(Throwable t, Configuration conf) {
        LOG.error("failtask: Killing task: {} ", (Object)conf.get("mapred.task.id"));
        try {
            JobClient jobClient = new JobClient((JobConf)conf);
            JobID jobId = JobID.forName((String)conf.get("mapred.job.id"));
            RunningJob job = jobClient.getJob(jobId);
            job.killTask(TaskAttemptID.forName((String)conf.get("mapred.task.id")), true);
        }
        catch (IOException ioe) {
            throw new GuaguaRuntimeException((Throwable)ioe);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.getGuaguaService().stop();
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public GuaguaService getGuaguaService() {
        return this.guaguaService;
    }

    public void setGuaguaService(GuaguaService guaguaService) {
        this.guaguaService = guaguaService;
    }
}

