/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.client;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class PrintInfo {
    public static void main(String[] args) {
        PrintInfo.printLogo();
        if (args.length == 1 && args[0].equals("v")) {
            PrintInfo.printVersion();
        } else {
            PrintInfo.printHelp();
        }
    }

    private static void printHelp() {
        System.out.println("Usage: guagua [-y(enable beta guagua-yarn version on hadoop 2.0)] jar <the jar containing master and worker class> [-D<hadoop/guagua property>] <parameters to jar>");
    }

    private static void printLogo() {
        System.out.println("  ____ _   _   _    ____ _   _   _    ");
        System.out.println(" / ___| | | | / \\  / ___| | | | / \\   ");
        System.out.println("| |  _| | | |/ _ \\| |  _| | | |/ _ \\  ");
        System.out.println("| |_| | |_| / ___ \\ |_| | |_| / ___ \\ ");
        System.out.println(" \\____|\\___/_/   \\_\\____|\\___/_/   \\_\\");
        System.out.println("                                      ");
    }

    private static void printVersion() {
        String findContainingJar = PrintInfo.findContainingJar(PrintInfo.class);
        JarFile jar = null;
        try {
            jar = new JarFile(findContainingJar);
            Manifest manifest = jar.getManifest();
            String vendor = manifest.getMainAttributes().getValue("vendor");
            String title = manifest.getMainAttributes().getValue("title");
            String version = manifest.getMainAttributes().getValue("version");
            String timestamp = manifest.getMainAttributes().getValue("timestamp");
            System.out.println(vendor + " " + title + " version " + version + " \ncompiled " + timestamp);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to read pigs manifest file", e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("jar closed failed", e);
                }
            }
        }
    }

    private static String findContainingJar(Class my_class) {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

