/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.specific;

import java.io.Serializable;
import org.encog.mathutil.matrices.BiPolarUtil;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataError;

public class BiPolarNeuralData
implements MLData,
Serializable {
    private static final long serialVersionUID = -6082894455587612231L;
    private boolean[] data;

    public BiPolarNeuralData(boolean[] d) {
        this.data = new boolean[d.length];
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public BiPolarNeuralData(int size) {
        this.data = new boolean[size];
    }

    @Override
    public final void add(int index, double value) {
        throw new MLDataError("Add is not supported for bipolar data.");
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = false;
        }
    }

    @Override
    public final MLData clone() {
        BiPolarNeuralData result = new BiPolarNeuralData(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setData(i, this.getData(i));
        }
        return result;
    }

    public final boolean getBoolean(int i) {
        return this.data[i];
    }

    @Override
    public final double[] getData() {
        return BiPolarUtil.bipolar2double(this.data);
    }

    @Override
    public final double getData(int index) {
        return BiPolarUtil.bipolar2double(this.data[index]);
    }

    @Override
    public final void setData(double[] theData) {
        this.data = BiPolarUtil.double2bipolar(theData);
    }

    public final void setData(int index, boolean value) {
        this.data[index] = value;
    }

    @Override
    public final void setData(int index, double d) {
        this.data[index] = BiPolarUtil.double2bipolar(d);
    }

    @Override
    public final int size() {
        return this.data.length;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (this.getData(i) > 0.0) {
                result.append("T");
            } else {
                result.append("F");
            }
            if (i == this.size() - 1) continue;
            result.append(",");
        }
        result.append(']');
        return result.toString();
    }
}

