/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class HDPUtils {
    public static String getHdpVersionForHDP224() {
        String hdfsJarWithVersion = HDPUtils.findContainingJar(DistributedFileSystem.class);
        String hdpVersion = "";
        if (hdfsJarWithVersion != null) {
            if (hdfsJarWithVersion.contains(File.separator)) {
                hdfsJarWithVersion = hdfsJarWithVersion.substring(hdfsJarWithVersion.lastIndexOf(File.separator) + 1);
            }
            hdfsJarWithVersion = hdfsJarWithVersion.replace("hadoop-hdfs-", "");
            String[] splits = (hdfsJarWithVersion = hdfsJarWithVersion.replace(".jar", "")).split("\\.");
            if (splits.length > 2) {
                for (int i = 3; i < splits.length; ++i) {
                    hdpVersion = i == splits.length - 1 ? hdpVersion + splits[i] : hdpVersion + splits[i] + ".";
                }
            }
        }
        return hdpVersion;
    }

    public static void addFileToClassPath(String file, Configuration conf) throws IOException {
        Path pathInHDFS = HDPUtils.shipToHDFS(conf, file);
        DistributedCache.addFileToClassPath((Path)pathInHDFS, (Configuration)conf, (FileSystem)FileSystem.get((Configuration)conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path shipToHDFS(Configuration conf, String fileName) throws IOException {
        Path dst = new Path("tmp", fileName.substring(fileName.lastIndexOf(File.separator) + 1));
        FileSystem fs = dst.getFileSystem(conf);
        OutputStream os = null;
        FSDataInputStream is = null;
        try {
            is = FileSystem.getLocal((Configuration)conf).open(new Path(fileName));
            os = fs.create(dst);
            org.apache.hadoop.io.IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)4096, (boolean)true);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            if (os != null) {
                os.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        if (os != null) {
            os.close();
        }
        return dst;
    }

    public static String findContainingFile(String fileName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> itr = null;
            if (loader instanceof URLClassLoader) {
                itr = ((URLClassLoader)loader).findResources(fileName);
            }
            if (itr == null || !itr.hasMoreElements()) {
                itr = loader.getResources(fileName);
            }
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"file".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String findContainingJar(Class my_class) {
        ClassLoader loader = my_class.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = null;
            if (loader instanceof URLClassLoader) {
                itr = ((URLClassLoader)loader).findResources(class_file);
            }
            if (itr == null || !itr.hasMoreElements()) {
                itr = loader.getResources(class_file);
            }
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

