/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.zookeeper.common.IOUtils;

public class GuaguaSplitWriter {
    private static final Log LOG = LogFactory.getLog(JobSplitWriter.class);
    static final int META_SPLIT_VERSION = 1;
    private static final int splitVersion = 1;
    static final byte[] META_SPLIT_FILE_HEADER;
    private static final byte[] SPLIT_FILE_HEADER;
    static final String MAX_SPLIT_LOCATIONS = "mapreduce.job.max.split.locations";

    public static <T extends InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, List<InputSplit> splits) throws IOException, InterruptedException {
        InputSplit[] array = splits.toArray(new InputSplit[splits.size()]);
        GuaguaSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)conf, (FileSystem)fs, (InputSplit[])array);
    }

    public static <T extends InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, T[] splits) throws IOException, InterruptedException {
        FSDataOutputStream out = GuaguaSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile((Path)jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = GuaguaSplitWriter.writeNewSplits((Configuration)conf, splits, (FSDataOutputStream)out);
        out.close();
        GuaguaSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile((Path)jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    public static void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, org.apache.hadoop.mapred.InputSplit[] splits) throws IOException {
        FSDataOutputStream out = GuaguaSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile((Path)jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = GuaguaSplitWriter.writeOldSplits(splits, out, conf);
        out.close();
        GuaguaSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile((Path)jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    private static FSDataOutputStream createFile(FileSystem fs, Path splitFile, Configuration job) throws IOException {
        FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)splitFile, (FsPermission)new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
        int replication = job.getInt("mapred.submit.replication", 10);
        fs.setReplication(splitFile, (short)replication);
        GuaguaSplitWriter.writeSplitHeader(out);
        return out;
    }

    private static void writeSplitHeader(FSDataOutputStream out) throws IOException {
        out.write(SPLIT_FILE_HEADER);
        out.writeInt(1);
    }

    private static <T extends InputSplit> JobSplit.SplitMetaInfo[] writeNewSplits(Configuration conf, T[] array, FSDataOutputStream out) throws IOException, InterruptedException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[array.length];
        if (array.length != 0) {
            SerializationFactory factory = new SerializationFactory(conf);
            int i = 0;
            long offset = out.getPos();
            for (T split : array) {
                long prevCount = out.getPos();
                Text.writeString((DataOutput)out, (String)split.getClass().getName());
                Serializer serializer = factory.getSerializer(split.getClass());
                serializer.open((OutputStream)out);
                serializer.serialize(split);
                long currCount = out.getPos();
                String[] locations = split.getLocations();
                int max_loc = conf.getInt(MAX_SPLIT_LOCATIONS, 10);
                if (locations.length > max_loc) {
                    LOG.warn((Object)("Max block location exceeded for split: " + split + " splitsize: " + locations.length + " maxsize: " + max_loc));
                    locations = Arrays.copyOf(locations, max_loc);
                }
                info[i++] = new JobSplit.SplitMetaInfo(locations, offset, split.getLength());
                offset += currCount - prevCount;
            }
        }
        return info;
    }

    private static JobSplit.SplitMetaInfo[] writeOldSplits(org.apache.hadoop.mapred.InputSplit[] splits, FSDataOutputStream out, Configuration conf) throws IOException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[splits.length];
        if (splits.length != 0) {
            int i = 0;
            long offset = out.getPos();
            for (org.apache.hadoop.mapred.InputSplit split : splits) {
                long prevLen = out.getPos();
                Text.writeString((DataOutput)out, (String)split.getClass().getName());
                split.write((DataOutput)out);
                long currLen = out.getPos();
                String[] locations = split.getLocations();
                int max_loc = conf.getInt(MAX_SPLIT_LOCATIONS, 10);
                if (locations.length > max_loc) {
                    LOG.warn((Object)("Max block location exceeded for split: " + split + " splitsize: " + locations.length + " maxsize: " + max_loc));
                    locations = Arrays.copyOf(locations, max_loc);
                }
                info[i++] = new JobSplit.SplitMetaInfo(locations, offset, split.getLength());
                offset += currLen - prevLen;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeJobSplitMetaInfo(FileSystem fs, Path filename, FsPermission p, int splitMetaInfoVersion, JobSplit.SplitMetaInfo[] allSplitMetaInfo) throws IOException {
        FSDataOutputStream out = null;
        try {
            out = FileSystem.create((FileSystem)fs, (Path)filename, (FsPermission)p);
            out.write(META_SPLIT_FILE_HEADER);
            WritableUtils.writeVInt((DataOutput)out, (int)splitMetaInfoVersion);
            WritableUtils.writeVInt((DataOutput)out, (int)allSplitMetaInfo.length);
            for (JobSplit.SplitMetaInfo splitMetaInfo : allSplitMetaInfo) {
                splitMetaInfo.write((DataOutput)out);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    static {
        try {
            META_SPLIT_FILE_HEADER = "META-SPL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
        try {
            SPLIT_FILE_HEADER = "SPL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }
}

