/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script;

import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.script.AnalystClassItem;

public class DataField {
    private String name;
    private double min;
    private double max;
    private double mean;
    private double standardDeviation;
    private boolean isInteger;
    private boolean isReal;
    private boolean isClass;
    private boolean isComplete;
    private final List<AnalystClassItem> classMembers = new ArrayList<AnalystClassItem>();

    public DataField(String theName) {
        this.name = theName;
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.mean = Double.NaN;
        this.standardDeviation = Double.NaN;
        this.isInteger = true;
        this.isReal = true;
        this.isClass = true;
        this.isComplete = true;
    }

    public final List<AnalystClassItem> getClassMembers() {
        return this.classMembers;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getMean() {
        return this.mean;
    }

    public final double getMin() {
        return this.min;
    }

    public final int getMinClassCount() {
        int cmin = Integer.MAX_VALUE;
        for (AnalystClassItem cls : this.classMembers) {
            cmin = Math.min(cmin, cls.getCount());
        }
        return cmin;
    }

    public final String getName() {
        return this.name;
    }

    public final double getStandardDeviation() {
        return this.standardDeviation;
    }

    public final boolean isClass() {
        return this.isClass;
    }

    public final boolean isComplete() {
        return this.isComplete;
    }

    public final boolean isInteger() {
        return this.isInteger;
    }

    public final boolean isReal() {
        return this.isReal;
    }

    public final void setClass(boolean theClass) {
        this.isClass = theClass;
    }

    public final void setComplete(boolean theComplete) {
        this.isComplete = theComplete;
    }

    public final void setInteger(boolean theInteger) {
        this.isInteger = theInteger;
    }

    public final void setMax(double theMax) {
        this.max = theMax;
    }

    public final void setMean(double theMean) {
        this.mean = theMean;
    }

    public final void setMin(double theMin) {
        this.min = theMin;
    }

    public final void setName(String theName) {
        this.name = theName;
    }

    public final void setReal(boolean theReal) {
        this.isReal = theReal;
    }

    public final void setStandardDeviation(double theStandardDeviation) {
        this.standardDeviation = theStandardDeviation;
    }
}

