/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic;

import org.encog.ml.genetic.GeneticAlgorithm;
import org.encog.ml.genetic.MateWorker;
import org.encog.ml.genetic.genome.Genome;
import org.encog.util.concurrency.EngineConcurrency;
import org.encog.util.concurrency.TaskGroup;

public class BasicGeneticAlgorithm
extends GeneticAlgorithm {
    private boolean first = true;

    @Override
    public final void iteration() {
        if (this.first) {
            EngineConcurrency.getInstance().setThreadCount(this.getThreadCount());
            this.getPopulation().claim(this);
            this.first = false;
        }
        int countToMate = (int)((double)this.getPopulation().getPopulationSize() * this.getPercentToMate());
        int offspringCount = countToMate * 2;
        int offspringIndex = this.getPopulation().getPopulationSize() - offspringCount;
        int matingPopulationSize = (int)((double)this.getPopulation().getPopulationSize() * this.getMatingPopulation());
        TaskGroup group = EngineConcurrency.getInstance().createTaskGroup();
        for (int i = 0; i < countToMate; ++i) {
            Genome mother = this.getPopulation().getGenomes().get(i);
            int fatherInt = (int)(Math.random() * (double)matingPopulationSize);
            Genome father = this.getPopulation().getGenomes().get(fatherInt);
            Genome child1 = this.getPopulation().getGenomes().get(offspringIndex);
            Genome child2 = this.getPopulation().getGenomes().get(offspringIndex + 1);
            MateWorker worker = new MateWorker(mother, father, child1, child2);
            EngineConcurrency.getInstance().processTask(worker, group);
            offspringIndex += 2;
        }
        group.waitForComplete();
        this.getPopulation().sort();
    }
}

