/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.mutate;

import org.encog.ml.genetic.genes.DoubleGene;
import org.encog.ml.genetic.genes.Gene;
import org.encog.ml.genetic.genome.Chromosome;
import org.encog.ml.genetic.mutate.Mutate;

public class MutatePerturb
implements Mutate {
    private final double perturbAmount;

    public MutatePerturb(double thePerturbAmount) {
        this.perturbAmount = thePerturbAmount;
    }

    @Override
    public final void performMutation(Chromosome chromosome) {
        for (Gene gene : chromosome.getGenes()) {
            if (!(gene instanceof DoubleGene)) continue;
            DoubleGene doubleGene = (DoubleGene)gene;
            double value = doubleGene.getValue();
            doubleGene.setValue(value += this.perturbAmount - Math.random() * this.perturbAmount * 2.0);
        }
    }
}

