/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.back;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.flat.train.prop.TrainFlatNetworkBackPropagation;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.Momentum;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.propagation.Propagation;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.neural.networks.training.strategy.SmartLearningRate;
import org.encog.neural.networks.training.strategy.SmartMomentum;
import org.encog.util.validate.ValidateNetwork;

public class Backpropagation
extends Propagation
implements Momentum,
LearningRate {
    public static final String LAST_DELTA = "LAST_DELTA";

    public Backpropagation(ContainsFlat network, MLDataSet training) {
        this(network, training, 0.0, 0.0);
        this.addStrategy(new SmartLearningRate());
        this.addStrategy(new SmartMomentum());
    }

    public Backpropagation(ContainsFlat network, MLDataSet training, double learnRate, double momentum) {
        super(network, training);
        ValidateNetwork.validateMethodToData(network, training);
        TrainFlatNetworkBackPropagation backFlat = new TrainFlatNetworkBackPropagation(network.getFlat(), this.getTraining(), learnRate, momentum);
        this.setFlatTraining(backFlat);
    }

    @Override
    public final boolean canContinue() {
        return false;
    }

    public final double[] getLastDelta() {
        return ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).getLastDelta();
    }

    @Override
    public final double getLearningRate() {
        return ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).getLearningRate();
    }

    @Override
    public final double getMomentum() {
        return ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).getMomentum();
    }

    public final boolean isValidResume(TrainingContinuation state) {
        if (!state.getContents().containsKey(LAST_DELTA)) {
            return false;
        }
        if (!state.getTrainingType().equals(this.getClass().getSimpleName())) {
            return false;
        }
        double[] d = (double[])state.get(LAST_DELTA);
        return d.length == ((ContainsFlat)this.getMethod()).getFlat().getWeights().length;
    }

    @Override
    public final TrainingContinuation pause() {
        TrainingContinuation result = new TrainingContinuation();
        result.setTrainingType(this.getClass().getSimpleName());
        TrainFlatNetworkBackPropagation backFlat = (TrainFlatNetworkBackPropagation)this.getFlatTraining();
        double[] d = backFlat.getLastDelta();
        result.set(LAST_DELTA, d);
        return result;
    }

    @Override
    public final void resume(TrainingContinuation state) {
        if (!this.isValidResume(state)) {
            throw new TrainingError("Invalid training resume data length");
        }
        ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).setLastDelta((double[])state.get(LAST_DELTA));
    }

    @Override
    public final void setLearningRate(double rate) {
        ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).setLearningRate(rate);
    }

    @Override
    public final void setMomentum(double m) {
        ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).setLearningRate(m);
    }
}

