/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.neural.som.SOM;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;

public class PersistSOM
implements EncogPersistor {
    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final String getPersistClassString() {
        return "SOM";
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        SOM result = new SOM();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("SOM") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (!section.getSectionName().equals("SOM") || !section.getSubSectionName().equals("NETWORK")) continue;
            params = section.parseParams();
            result.setWeights(EncogFileSection.parseMatrix(params, "weights"));
            result.setOutputNeuronCount(EncogFileSection.parseInt(params, "outputCount"));
            result.setInputCount(EncogFileSection.parseInt(params, "inputCount"));
        }
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        SOM som = (SOM)obj;
        out.addSection("SOM");
        out.addSubSection("PARAMS");
        out.addProperties(som.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("weights", som.getWeights());
        out.writeProperty("inputCount", som.getInputCount());
        out.writeProperty("outputCount", som.getOutputNeuronCount());
        out.flush();
    }
}

