/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.coordinator.zk.GuaguaZooKeeper;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.Serializer;
import ml.shifu.guagua.util.NumberFormatUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(BasicCoordinator.class);
    private GuaguaZooKeeper zooKeeper;
    private CountDownLatch zkConnLatch = new CountDownLatch(1);
    protected static final int WAIT_SLOT_MILLS = 300;
    private long sleepTime = 300L;
    private boolean isFixedTime = true;
    private Serializer<MASTER_RESULT> masterSerializer;
    private Serializer<WORKER_RESULT> workerSerializer;
    private HeartBeat heartBeat;
    private static final long HEART_BEAT_SLEEP_TIME = 15000L;
    private boolean zkHeartBeatEnabled = false;

    protected StringBuilder getMasterBaseNode(String appId) {
        return new StringBuilder(50).append((CharSequence)this.getAppNode(appId)).append("/").append("master");
    }

    protected StringBuilder getMasterNode(String appId, int iteration) {
        return new StringBuilder(50).append((CharSequence)this.getMasterBaseNode(appId)).append("/").append(iteration);
    }

    protected StringBuilder getCurrentMasterNode(String appId, int iteration) {
        return this.getMasterNode(appId, iteration);
    }

    protected StringBuilder getCurrentMasterSplitNode(String appId, int iteration) {
        return new StringBuilder(50).append((CharSequence)this.getMasterBaseNode(appId)).append("/").append("split").append("/").append(iteration);
    }

    protected StringBuilder getLastMasterNode(String appId, int iteration) {
        return this.getMasterNode(appId, iteration - 1);
    }

    protected StringBuilder getRootNode() {
        return new StringBuilder(10).append("/").append("_guagua");
    }

    protected StringBuilder getBaseMasterElectionNode(String appId) {
        return new StringBuilder(20).append((CharSequence)this.getAppNode(appId)).append("/").append("master_election");
    }

    protected StringBuilder getMasterElectionNode(String appId, long sessionId) {
        return new StringBuilder(40).append((CharSequence)this.getBaseMasterElectionNode(appId)).append("/").append(sessionId);
    }

    protected StringBuilder getAppNode(String appId) {
        return new StringBuilder(20).append((CharSequence)this.getRootNode()).append("/").append(appId);
    }

    protected StringBuilder getWorkerBaseNode(String appId) {
        return new StringBuilder(50).append((CharSequence)this.getAppNode(appId)).append("/").append("workers");
    }

    protected StringBuilder getWorkerBaseNode(String appId, int iteration) {
        return new StringBuilder(50).append((CharSequence)this.getWorkerBaseNode(appId)).append("/").append(iteration);
    }

    protected StringBuilder getWorkerNode(String appId, String containerId, int iteration) {
        return new StringBuilder(50).append((CharSequence)this.getWorkerBaseNode(appId, iteration)).append("/").append(containerId);
    }

    protected StringBuilder getCurrentWorkerNode(String appId, String containerId, int iteration) {
        return this.getWorkerNode(appId, containerId, iteration);
    }

    protected StringBuilder getCurrentWorkerSplitNode(String appId, String containerId, int iteration) {
        return new StringBuilder(50).append((CharSequence)this.getAppNode(appId)).append("/").append("workers").append("/").append("split").append("/").append(iteration).append("/").append(containerId);
    }

    protected StringBuilder getLastWorkerNode(String appId, String containerId, int iteration) {
        return this.getWorkerNode(appId, containerId, iteration - 1);
    }

    protected void initialize(Properties props) {
        this.zkHeartBeatEnabled = Boolean.TRUE.toString().equalsIgnoreCase(props.getProperty("guagua.zk.heartbeat.enabled", Boolean.FALSE.toString()));
        this.checkAndSetZooKeeper(props);
        this.setSleepTime(NumberFormatUtils.getLong(props.getProperty("guagua.coordinator.sleep.unit"), 300L));
        this.setFixedTime(Boolean.TRUE.toString().equalsIgnoreCase(props.getProperty("guagua.coordinator.fixed.sleep.enable", "true")));
    }

    protected void checkAndSetZooKeeper(Properties props) {
        if (this.getZooKeeper() == null) {
            try {
                String zkServers = props.getProperty("guagua.zk.servers");
                if (zkServers == null || zkServers.length() == 0) {
                    throw new GuaguaRuntimeException("Not set 'guagua.zk.servers'. Should be set for coordination.");
                }
                int sessionTimeout = NumberFormatUtils.getInt(props.getProperty("guagua.zk.session.timeout"), 300000);
                int maxRetryAttempts = NumberFormatUtils.getInt(props.getProperty("guagua.zk.max.attempt"), 5);
                int retryWaitMsecs = NumberFormatUtils.getInt(props.getProperty("guagua.zk.retry.wait.mills"), 1000);
                this.setZooKeeper(new GuaguaZooKeeper(zkServers, sessionTimeout, maxRetryAttempts, retryWaitMsecs, this));
                this.getZkConnLatch().await();
            }
            catch (IOException e) {
                throw new GuaguaRuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new GuaguaRuntimeException(e);
            }
        }
        if (this.zkHeartBeatEnabled) {
            this.startHeartbeat();
        }
    }

    protected void closeZooKeeper() throws InterruptedException {
        if (this.zkHeartBeatEnabled) {
            this.stopHeartBeat();
        }
        if (this.getZooKeeper() != null) {
            this.getZooKeeper().close();
        }
    }

    protected void startHeartbeat() {
        this.heartBeat = new HeartBeat();
        this.heartBeat.setDaemon(true);
        this.heartBeat.setName("ZooKeeper HeartBeat");
    }

    protected void stopHeartBeat() throws InterruptedException {
        this.heartBeat.setFollow(false);
        this.heartBeat.interrupt();
        this.heartBeat.join(16000L);
    }

    public void process(WatchedEvent event) {
        LOG.debug("process: Got a new event, path = {}, type = {}, state = {}", new Object[]{event.getPath(), event.getType(), event.getState()});
        if (event.getPath() == null && event.getType() == Watcher.Event.EventType.None) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                LOG.info("process: Asynchronous connection complete.");
                this.getZkConnLatch().countDown();
            } else {
                LOG.warn("process: Got unknown null path event {}.", (Object)event);
            }
            return;
        }
    }

    protected boolean setBytesToZNode(String znode, String splitZnode, byte[] bytes, CreateMode createNode) throws KeeperException, InterruptedException {
        LOG.debug("bytes length:{}", (Object)bytes.length);
        int zkDataLimit = 1047552;
        if (bytes.length > 1047552) {
            this.getZooKeeper().createExt(splitZnode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
            int childrenSize = bytes.length % 1047552 == 0 ? bytes.length / 1047552 : bytes.length / 1047552 + 1;
            int currentLen = bytes.length;
            for (int i = 0; i < childrenSize; ++i) {
                byte[] currentBytes;
                if (currentLen >= 1047552) {
                    currentLen -= 1047552;
                    currentBytes = new byte[1047552];
                } else {
                    currentBytes = new byte[currentLen];
                }
                System.arraycopy(bytes, i * 1047552, currentBytes, 0, currentBytes.length);
                this.getZooKeeper().createExt(splitZnode + "/" + i, currentBytes, ZooDefs.Ids.OPEN_ACL_UNSAFE, createNode, false);
            }
            this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, createNode, false);
            return true;
        }
        this.getZooKeeper().createExt(znode, bytes, ZooDefs.Ids.OPEN_ACL_UNSAFE, createNode, false);
        return false;
    }

    protected byte[] getBytesFromZNode(String znode, String splitZnode) throws KeeperException, InterruptedException {
        byte[] data = this.getZooKeeper().getData(znode, null, null);
        if (data != null) {
            return data;
        }
        List<String> children = this.getZooKeeper().getChildrenExt(splitZnode, false, true, new ChildrenComparator());
        if (children == null || children.size() == 0) {
            return null;
        }
        ArrayList<byte[]> bytesList = new ArrayList<byte[]>(children.size());
        int wholeLength = 0;
        for (int i = 0; i < children.size(); ++i) {
            byte[] currentBytes = this.getZooKeeper().getData(children.get(i), null, null);
            if (currentBytes == null) continue;
            wholeLength += currentBytes.length;
            bytesList.add(currentBytes);
        }
        byte[] results = new byte[wholeLength];
        int currentLength = 0;
        for (int i = 0; i < bytesList.size(); ++i) {
            byte[] currentBytes = (byte[])bytesList.get(i);
            if (currentBytes == null) continue;
            System.arraycopy(currentBytes, 0, results, currentLength, currentBytes.length);
            currentLength += currentBytes.length;
        }
        LOG.debug("znode results.length:{}", (Object)results.length);
        return results;
    }

    public GuaguaZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(GuaguaZooKeeper zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public boolean isFixedTime() {
        return this.isFixedTime;
    }

    public void setFixedTime(boolean isFixedTime) {
        this.isFixedTime = isFixedTime;
    }

    public Serializer<WORKER_RESULT> getWorkerSerializer() {
        return this.workerSerializer;
    }

    public void setWorkerSerializer(Serializer<WORKER_RESULT> workerSerializer) {
        this.workerSerializer = workerSerializer;
    }

    public Serializer<MASTER_RESULT> getMasterSerializer() {
        return this.masterSerializer;
    }

    public void setMasterSerializer(Serializer<MASTER_RESULT> masterSerializer) {
        this.masterSerializer = masterSerializer;
    }

    public CountDownLatch getZkConnLatch() {
        return this.zkConnLatch;
    }

    public static abstract class RetryCoordinatorCommand
    extends BasicCoordinatorCommand {
        private long sleepUnitTime = 300L;
        private boolean isFixedTime = true;
        private long startTime = 0L;

        public RetryCoordinatorCommand(boolean isFixedTime, long sleepUnitTime) {
            this.isFixedTime = isFixedTime;
            this.sleepUnitTime = sleepUnitTime;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public void doExecute() throws Exception, InterruptedException {
            int attempt = 0;
            do {
                ++attempt;
                if (this.isFixedTime) {
                    Thread.sleep(this.sleepUnitTime);
                } else {
                    Thread.sleep((long)attempt * this.sleepUnitTime);
                }
                if (!this.retryExecution()) continue;
                return;
            } while (attempt < Integer.MAX_VALUE);
        }

        public abstract boolean retryExecution() throws Exception, InterruptedException;

        public long getElapsedTime() {
            return System.currentTimeMillis() - this.startTime;
        }

        protected boolean isTerminated(int workersCompleted, int workers, double minWorkersRatio, long minWorkersTimeout) {
            LOG.debug("DEBUG: workersCompleted={}, workers={}, minWorkersRatio={}, minWorkersTimeout={}", new Object[]{workersCompleted, workers, minWorkersRatio, minWorkersTimeout});
            return workers == workersCompleted || this.getElapsedTime() >= minWorkersTimeout && workersCompleted >= (int)((double)workers * minWorkersRatio);
        }
    }

    public static abstract class BasicCoordinatorCommand
    implements CoordinatorCommand {
        @Override
        public void execute() {
            try {
                this.doExecute();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new GuaguaRuntimeException(e);
            }
        }

        public abstract void doExecute() throws Exception, InterruptedException;
    }

    public static interface CoordinatorCommand {
        public void execute();
    }

    private class HeartBeat
    extends Thread {
        private volatile boolean follow = true;

        private HeartBeat() {
        }

        @Override
        public void run() {
            while (this.isFollow()) {
                try {
                    Thread.sleep(15000L);
                    LOG.debug("DEBUG: Heartbeat.");
                    Stat exists = BasicCoordinator.this.getZooKeeper().exists(BasicCoordinator.this.getRootNode().toString(), false);
                    LOG.debug("DEBUG: Heartbeat {}", (Object)exists);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException.SessionExpiredException e) {
                    throw new GuaguaRuntimeException(e);
                }
                catch (KeeperException e) {
                    if (System.nanoTime() % 20L != 0L) continue;
                    LOG.info("Heartbeat zookeeper exception, can be ignored.");
                }
            }
        }

        public boolean isFollow() {
            return this.follow;
        }

        public void setFollow(boolean follow) {
            this.follow = follow;
        }
    }

    private static class ChildrenComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 7871289234100249905L;

        private ChildrenComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return Integer.valueOf(s1).compareTo(Integer.valueOf(s2));
        }
    }
}

