/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.io;

import java.nio.charset.Charset;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.BytableSerializer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;

public class NettyBytableDecoder
extends LengthFieldBasedFrameDecoder {
    private BytableSerializer<Bytable> serializer = new BytableSerializer();

    public NettyBytableDecoder() {
        this(0x4000000);
    }

    public NettyBytableDecoder(int maxObjectSize) {
        super(maxObjectSize, 0, 4, 0, 4);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        ChannelBuffer frame = (ChannelBuffer)super.decode(ctx, channel, buffer);
        if (frame == null) {
            return null;
        }
        int classNameSize = frame.readInt();
        byte[] classNameBytes = new byte[classNameSize];
        frame.readBytes(classNameBytes);
        String className = new String(classNameBytes, Charset.forName("UTF-8"));
        int readableBytes = frame.readableBytes();
        byte[] objectBytes = new byte[readableBytes];
        frame.readBytes(objectBytes);
        Bytable bytesToObject = this.serializer.bytesToObject(objectBytes, className);
        return bytesToObject;
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

