/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop.io;

import java.io.IOException;
import ml.shifu.guagua.hadoop.io.GuaguaWritableAdapter;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.GuaguaRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.SequenceFileAsTextRecordReader;

public class GuaguaSequenceAsTextRecordReader
implements GuaguaRecordReader<GuaguaWritableAdapter<Text>, GuaguaWritableAdapter<Text>> {
    private SequenceFileAsTextRecordReader sequenceReader;
    private Configuration conf;
    private GuaguaWritableAdapter<Text> key = null;
    private GuaguaWritableAdapter<Text> value = null;

    public GuaguaSequenceAsTextRecordReader() {
        this.conf = new Configuration();
    }

    public GuaguaSequenceAsTextRecordReader(GuaguaFileSplit split) throws IOException {
        this(new Configuration(), split);
    }

    public GuaguaSequenceAsTextRecordReader(Configuration conf, GuaguaFileSplit split) throws IOException {
        this.conf = conf;
        this.initialize(split);
    }

    public float getProgress() throws IOException {
        return this.sequenceReader.getProgress();
    }

    public void initialize(GuaguaFileSplit split) throws IOException {
        FileSplit fileSplit = new FileSplit(new Path(split.getPath()), split.getOffset(), split.getLength(), (String[])null);
        this.sequenceReader = new SequenceFileAsTextRecordReader(this.conf, fileSplit);
    }

    public boolean nextKeyValue() throws IOException {
        if (this.key == null) {
            this.key = new GuaguaWritableAdapter<Text>(new Text());
        }
        if (this.value == null) {
            this.value = new GuaguaWritableAdapter<Text>(new Text());
        }
        return this.sequenceReader.next(this.key.getWritable(), this.value.getWritable());
    }

    public GuaguaWritableAdapter<Text> getCurrentKey() {
        return this.key;
    }

    public GuaguaWritableAdapter<Text> getCurrentValue() {
        return this.value;
    }

    public synchronized void close() throws IOException {
        if (this.sequenceReader != null) {
            this.sequenceReader.close();
        }
    }
}

