/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.AnalystClusterCSV;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.util.csv.CSVFormat;
import org.encog.util.logging.EncogLogging;

public class CmdCluster
extends Cmd {
    public static final int DEFAULT_ITERATIONS = 100;
    public static final String COMMAND_NAME = "CLUSTER";

    public CmdCluster(EncogAnalyst analyst) {
        super(analyst);
    }

    @Override
    public final boolean executeCommand(String args) {
        String sourceID = this.getProp().getPropertyString("CLUSTER:CONFIG_sourceFile");
        String targetID = this.getProp().getPropertyString("CLUSTER:CONFIG_targetFile");
        int clusters = this.getProp().getPropertyInt("CLUSTER:CONFIG_clusters");
        this.getProp().getPropertyString("CLUSTER:CONFIG_type");
        EncogLogging.log(0, "Beginning cluster");
        EncogLogging.log(0, "source file:" + sourceID);
        EncogLogging.log(0, "target file:" + targetID);
        EncogLogging.log(0, "clusters:" + clusters);
        File sourceFile = this.getScript().resolveFilename(sourceID);
        File targetFile = this.getScript().resolveFilename(targetID);
        CSVFormat inputFormat = this.getScript().determineInputFormat(sourceID);
        CSVFormat outputFormat = this.getScript().determineOutputFormat();
        this.getScript().markGenerated(targetID);
        AnalystClusterCSV cluster = new AnalystClusterCSV();
        cluster.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(cluster);
        cluster.setReport(new AnalystReportBridge(this.getAnalyst()));
        boolean headers = this.getScript().expectInputHeaders(sourceID);
        cluster.analyze(this.getAnalyst(), sourceFile, headers, inputFormat);
        cluster.setOutputFormat(outputFormat);
        cluster.process(targetFile, clusters, this.getAnalyst(), 100);
        this.getAnalyst().setCurrentQuantTask(null);
        return cluster.shouldStop();
    }

    @Override
    public final String getName() {
        return COMMAND_NAME;
    }
}

