/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

import java.io.Serializable;
import org.encog.EncogError;

public class Equilateral
implements Serializable {
    public static final int MIN_EQ = 3;
    private final double[][] matrix;

    public Equilateral(int count, double high, double low) {
        this.matrix = this.equilat(count, high, low);
    }

    public final int decode(double[] activations) {
        double minValue = Double.POSITIVE_INFINITY;
        int minSet = -1;
        for (int i = 0; i < this.matrix.length; ++i) {
            double dist = this.getDistance(activations, i);
            if (!(dist < minValue)) continue;
            minValue = dist;
            minSet = i;
        }
        return minSet;
    }

    public final double[] encode(int set) {
        if (set > this.matrix.length) {
            throw new EncogError("Class out of range for equilateral: " + set);
        }
        return this.matrix[set];
    }

    private double[][] equilat(int n, double high, double low) {
        double[][] result = new double[n][n - 1];
        result[0][0] = -1.0;
        result[1][0] = 1.0;
        for (int k = 2; k < n; ++k) {
            int i;
            double r = k;
            double f = Math.sqrt(r * r - 1.0) / r;
            for (i = 0; i < k; ++i) {
                int j = 0;
                while (j < k - 1) {
                    double[] dArray = result[i];
                    int n2 = j++;
                    dArray[n2] = dArray[n2] * f;
                }
            }
            r = -1.0 / r;
            for (i = 0; i < k; ++i) {
                result[i][k - 1] = r;
            }
            for (i = 0; i < k - 1; ++i) {
                result[k][i] = 0.0;
            }
            result[k][k - 1] = 1.0;
        }
        for (int row = 0; row < result.length; ++row) {
            for (int col = 0; col < result[0].length; ++col) {
                double min = -1.0;
                double max = 1.0;
                result[row][col] = (result[row][col] - -1.0) / 2.0 * (high - low) + low;
            }
        }
        return result;
    }

    public final double getDistance(double[] data, int set) {
        double result = 0.0;
        for (int i = 0; i < data.length; ++i) {
            result += Math.pow(data[i] - this.matrix[set][i], 2.0);
        }
        return Math.sqrt(result);
    }
}

