/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.TrainingSetScore;
import org.encog.neural.networks.training.anneal.NeuralSimulatedAnnealing;
import org.encog.util.ParamsHolder;

public class AnnealFactory {
    public final MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof BasicNetwork)) {
            throw new TrainingError("Invalid method type, requires BasicNetwork");
        }
        TrainingSetScore score = new TrainingSetScore(training);
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        ParamsHolder holder = new ParamsHolder(args);
        double startTemp = holder.getDouble("startTemp", false, 10.0);
        double stopTemp = holder.getDouble("stopTemp", false, 2.0);
        int cycles = holder.getInt("cycles", false, 100);
        NeuralSimulatedAnnealing train = new NeuralSimulatedAnnealing((BasicNetwork)method, score, startTemp, stopTemp, cycles);
        return train;
    }
}

