/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLError;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.som.training.basic.BestMatchingUnit;
import org.encog.util.EngineArray;

public class SOM
extends BasicML
implements MLClassification,
MLResettable,
MLError {
    private static final long serialVersionUID = 1L;
    public static final double VERYSMALL = 1.0E-30;
    private Matrix weights;
    protected int inputNeuronCount;
    protected int outputNeuronCount;

    public SOM() {
    }

    public SOM(int inputCount, int outputCount) {
        this.inputNeuronCount = inputCount;
        this.outputNeuronCount = outputCount;
        this.weights = new Matrix(inputCount, outputCount);
    }

    @Override
    public final double calculateError(MLDataSet data) {
        BestMatchingUnit bmu = new BestMatchingUnit(this);
        bmu.reset();
        for (MLDataPair pair : data) {
            MLData input = pair.getInput();
            bmu.calculateBMU(input);
        }
        return bmu.getWorstDistance() / 100.0;
    }

    @Override
    public final int classify(MLData input) {
        MLData result = this.compute(input);
        return EngineArray.maxIndex(result.getData());
    }

    public final MLData compute(MLData input) {
        BasicMLData result = new BasicMLData(this.outputNeuronCount);
        for (int i = 0; i < this.outputNeuronCount; ++i) {
            Matrix optr = this.weights.getCol(i);
            Matrix inputMatrix = Matrix.createRowMatrix(input.getData());
            result.setData(i, MatrixMath.dotProduct(inputMatrix, optr));
        }
        return result;
    }

    @Override
    public final int getInputCount() {
        return this.inputNeuronCount;
    }

    public final int getInputNeuronCount() {
        return this.inputNeuronCount;
    }

    @Override
    public final int getOutputCount() {
        return 1;
    }

    public final int getOutputNeuronCount() {
        return this.outputNeuronCount;
    }

    public final Matrix getWeights() {
        return this.weights;
    }

    @Override
    public final void reset() {
        this.weights.randomize(-1.0, 1.0);
    }

    @Override
    public final void reset(int seed) {
        this.reset();
    }

    public final void setInputCount(int i) {
        this.inputNeuronCount = i;
    }

    public final void setOutputNeuronCount(int i) {
        this.outputNeuronCount = i;
    }

    public final void setWeights(Matrix weights) {
        this.weights = weights;
    }

    @Override
    public final void updateProperties() {
    }

    public final int winner(MLData input) {
        MLData output = this.compute(input);
        int win = EngineArray.indexOfLargest(output.getData());
        return win;
    }
}

