/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.example.kmeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ml.shifu.guagua.io.HaltBytable;

public class KMeansWorkerParams
extends HaltBytable {
    private int k;
    private int c;
    private boolean isFirstIteration;
    private List<double[]> pointList;
    private List<Integer> countList;

    public void doWrite(DataOutput out) throws IOException {
        int i;
        this.validate();
        out.writeInt(this.k);
        out.writeInt(this.c);
        for (i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.c; ++j) {
                out.writeDouble(this.pointList.get(i)[j]);
            }
        }
        out.writeBoolean(this.isFirstIteration);
        if (!this.isFirstIteration && this.countList != null) {
            for (i = 0; i < this.k; ++i) {
                out.writeInt(this.countList.get(i));
            }
        }
    }

    private void validate() {
        this.validateK();
        this.validateC();
        if (this.k != this.pointList.size()) {
            throw new IllegalArgumentException("In-consistent sum list.");
        }
        if (!this.isFirstIteration && this.k != this.countList.size()) {
            throw new IllegalArgumentException("In-consistent count list.");
        }
    }

    public void doReadFields(DataInput in) throws IOException {
        this.k = in.readInt();
        this.validateK();
        this.c = in.readInt();
        this.validateC();
        this.pointList = new LinkedList<double[]>();
        for (int i = 0; i < this.k; ++i) {
            double[] units = new double[this.c];
            for (int j = 0; j < this.c; ++j) {
                units[j] = in.readDouble();
            }
            this.pointList.add(units);
        }
        boolean isFirstIteration = in.readBoolean();
        if (!isFirstIteration) {
            this.countList = new LinkedList<Integer>();
            for (int i = 0; i < this.k; ++i) {
                this.countList.add(in.readInt());
            }
        }
    }

    private void validateK() {
        if (this.k <= 0) {
            throw new IllegalArgumentException("'k' should be a positive number.");
        }
    }

    private void validateC() {
        if (this.c <= 0) {
            throw new IllegalArgumentException("'c' (cloumn number) should be a positive number.");
        }
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getC() {
        return this.c;
    }

    public void setC(int c) {
        this.c = c;
    }

    public List<double[]> getPointList() {
        return this.pointList;
    }

    public void setPointList(List<double[]> sumList) {
        this.pointList = sumList;
    }

    public List<Integer> getCountList() {
        return this.countList;
    }

    public void setCountList(List<Integer> countList) {
        this.countList = countList;
    }

    public boolean isFirstIteration() {
        return this.isFirstIteration;
    }

    public void setFirstIteration(boolean isFirstIteration) {
        this.isFirstIteration = isFirstIteration;
    }

    public String toString() {
        return "KMeansWorkerParams [k=" + this.k + ", c=" + this.c + ", sumList=" + this.pointList + ", countList=" + this.countList + "]";
    }
}

