/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.util.Iterator;
import java.util.List;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.util.AppendList;
import ml.shifu.guagua.util.SizeEstimator;

public class MemoryLimitedList<T>
implements AppendList<T> {
    private long maxByteSize = Long.MAX_VALUE;
    private long byteSize = 0L;
    private List<T> delegationList;
    private AppendList.State state = AppendList.State.WRITE;
    private long count;

    public MemoryLimitedList(long maxSize, List<T> delegationList) {
        this.maxByteSize = maxSize;
        this.delegationList = delegationList;
    }

    public MemoryLimitedList(List<T> delegationList) {
        this.delegationList = delegationList;
    }

    @Override
    public boolean append(T t) {
        if (this.state != AppendList.State.WRITE) {
            throw new IllegalStateException();
        }
        ++this.count;
        long current = SizeEstimator.estimate(t);
        if (this.byteSize + current > this.maxByteSize) {
            throw new GuaguaRuntimeException("List over size limit.");
        }
        this.byteSize += current;
        return this.delegationList.add(t);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.state != AppendList.State.READ) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){
            private Iterator<T> iter;
            {
                this.iter = MemoryLimitedList.this.delegationList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public T next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void switchState() {
        this.state = AppendList.State.READ;
    }

    @Override
    public int size() {
        return (int)this.count;
    }

    @Override
    public void clear() {
        this.delegationList.clear();
    }
}

