/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.ninja;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.app.analyst.csv.basic.BasicCachedFile;
import org.encog.app.quant.QuantError;
import org.encog.util.csv.ReadCSV;

public class NinjaFileConvert
extends BasicCachedFile {
    public final void process(File target) {
        try {
            ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getInputFormat());
            PrintWriter tw = new PrintWriter(new FileWriter(target));
            this.resetStatus();
            while (csv.next() && !this.shouldStop()) {
                StringBuilder line = new StringBuilder();
                this.updateStatus(false);
                line.append(this.getColumnData("date", csv));
                line.append(" ");
                line.append(this.getColumnData("time", csv));
                line.append(";");
                line.append(this.getInputFormat().format(Double.parseDouble(this.getColumnData("open", csv)), this.getPrecision()));
                line.append(";");
                line.append(this.getInputFormat().format(Double.parseDouble(this.getColumnData("high", csv)), this.getPrecision()));
                line.append(";");
                line.append(this.getInputFormat().format(Double.parseDouble(this.getColumnData("low", csv)), this.getPrecision()));
                line.append(";");
                line.append(this.getInputFormat().format(Double.parseDouble(this.getColumnData("close", csv)), this.getPrecision()));
                line.append(";");
                line.append(this.getInputFormat().format(Double.parseDouble(this.getColumnData("volume", csv)), this.getPrecision()));
                tw.println(line.toString());
            }
            this.reportDone(false);
            csv.close();
            tw.close();
        }
        catch (IOException ex) {
            throw new QuantError(ex);
        }
    }
}

