/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.kmeans;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.MLCluster;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.kmeans.Centroid;
import org.encog.ml.kmeans.KMeansClustering;

public class KMeansCluster
implements MLCluster {
    private Centroid centroid;
    private double sumSqr;
    private final List<MLData> data = new ArrayList<MLData>();

    @Override
    public final void add(MLData pair) {
        this.data.add(pair);
        this.calcSumOfSquares();
    }

    public final void calcSumOfSquares() {
        int size = this.data.size();
        double temp = 0.0;
        for (int i = 0; i < size; ++i) {
            temp += KMeansClustering.calculateEuclideanDistance(this.centroid, this.data.get(i));
        }
        this.sumSqr = temp;
    }

    @Override
    public final MLDataSet createDataSet() {
        BasicMLDataSet result = new BasicMLDataSet();
        for (MLData dataItem : this.data) {
            result.add(dataItem);
        }
        return result;
    }

    @Override
    public final MLData get(int pos) {
        return this.data.get(pos);
    }

    public final Centroid getCentroid() {
        return this.centroid;
    }

    @Override
    public final List<MLData> getData() {
        return this.data;
    }

    public final double getSumSqr() {
        return this.sumSqr;
    }

    @Override
    public final void remove(MLData pair) {
        this.data.remove(pair);
        this.calcSumOfSquares();
    }

    public final void setCentroid(Centroid c) {
        this.centroid = c;
    }

    @Override
    public final int size() {
        return this.data.size();
    }
}

