/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pnn;

import org.encog.ml.BasicML;
import org.encog.ml.data.MLData;
import org.encog.neural.pnn.PNNKernelType;
import org.encog.neural.pnn.PNNOutputMode;

public abstract class AbstractPNN
extends BasicML {
    private final int inputCount;
    private final int outputCount;
    private final PNNKernelType kernel;
    private final PNNOutputMode outputMode;
    private boolean trained;
    private double error;
    private int[] confusion;
    private final double[] deriv;
    private final double[] deriv2;
    private int exclude;
    private boolean separateClass;

    public AbstractPNN(PNNKernelType kernel, PNNOutputMode outputMode, int inputCount, int outputCount) {
        this.kernel = kernel;
        this.outputMode = outputMode;
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.trained = false;
        this.error = Double.MIN_VALUE;
        this.confusion = null;
        this.exclude = -1;
        this.deriv = new double[inputCount];
        this.deriv2 = new double[inputCount];
        if (this.outputMode == PNNOutputMode.Classification) {
            this.confusion = new int[this.outputCount + 1];
        }
    }

    public abstract MLData compute(MLData var1);

    public double[] getDeriv() {
        return this.deriv;
    }

    public double[] getDeriv2() {
        return this.deriv2;
    }

    public double getError() {
        return this.error;
    }

    public int getExclude() {
        return this.exclude;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public PNNKernelType getKernel() {
        return this.kernel;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public PNNOutputMode getOutputMode() {
        return this.outputMode;
    }

    public boolean isTrained() {
        return this.trained;
    }

    public void resetConfusion() {
    }

    public final void setError(double error) {
        this.error = error;
    }

    public final void setExclude(int exclude) {
        this.exclude = exclude;
    }

    public final void setTrained(boolean trained) {
        this.trained = trained;
    }

    public final boolean isSeparateClass() {
        return this.separateClass;
    }

    public final void setSeparateClass(boolean separateClass) {
        this.separateClass = separateClass;
    }
}

