/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.coordinator.zk.ZooKeeperUtils;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.master.BasicMasterInterceptor;
import ml.shifu.guagua.master.MasterContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperMasterInterceptor<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicMasterInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperMasterInterceptor.class);
    private FileSystem fileSystem;
    private Path zookeeperServerPath;
    private boolean isNeedStartZookeeper = false;

    public void preApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        String zkServers = context.getProps().getProperty("guagua.zk.servers");
        if (zkServers == null || zkServers.length() == 0 || !ZooKeeperUtils.checkServers((String)zkServers)) {
            String zookeeperServer;
            this.isNeedStartZookeeper = true;
            if (this.fileSystem == null) {
                try {
                    this.fileSystem = FileSystem.get((Configuration)new Configuration());
                }
                catch (IOException e) {
                    throw new GuaguaRuntimeException((Throwable)e);
                }
            }
            String localHostName = this.getLocalHostName();
            LOG.warn("No valid zookeeper servers, start one in ZooKeeperMaster {}", (Object)localHostName);
            String zkJavaOpts = context.getProps().getProperty("guagua.child.zkserver.opts", "-Xms512m -Xmx1024m -server -XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70");
            try {
                zookeeperServer = ZooKeeperUtils.startChildZooKeeperProcess((String)zkJavaOpts);
            }
            catch (IOException e) {
                LOG.error("Error in start child zookeeper process.", (Throwable)e);
                zookeeperServer = null;
            }
            if (zookeeperServer == null) {
                zookeeperServer = this.startZookeeperServer(localHostName);
                LOG.info("Zookeeper server is stated with thread: {}", (Object)zookeeperServer);
            } else {
                LOG.info("Zookeeper server is stated with child process: {}", (Object)zookeeperServer);
            }
            this.writeServerInfoToHDFS(context, zookeeperServer);
            context.getProps().setProperty("guagua.zk.servers", zookeeperServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeServerInfoToHDFS(MasterContext<MASTER_RESULT, WORKER_RESULT> context, String embededZooKeeperServer) {
        block8: {
            String hdfsZookeeperServerFolder = this.getZookeeperServerFolder(context);
            PrintWriter pw = null;
            try {
                if (!this.fileSystem.exists(new Path(hdfsZookeeperServerFolder))) {
                    this.fileSystem.mkdirs(new Path(hdfsZookeeperServerFolder));
                }
                this.zookeeperServerPath = this.fileSystem.makeQualified(new Path(hdfsZookeeperServerFolder, "zookeeper_server"));
                LOG.info("Writing hdfs zookeeper server info to {}", (Object)this.zookeeperServerPath);
                FSDataOutputStream fos = this.fileSystem.create(this.zookeeperServerPath);
                pw = new PrintWriter((OutputStream)fos);
                pw.println(embededZooKeeperServer);
                pw.flush();
                IOUtils.closeStream((Closeable)pw);
            }
            catch (IOException e) {
                LOG.error("Error in writing output.", (Throwable)e);
            }
            catch (Exception e2) {
                LOG.error("Error in writing output.", (Throwable)e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeStream(pw);
            }
        }
    }

    private String getZookeeperServerFolder(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        String defaultZooKeeperServePath = new StringBuilder(200).append("tmp").append("/").append("_guagua").append("/").append(context.getAppId()).append("/").toString();
        String hdfsZookeeperServerPath = context.getProps().getProperty("guagua.zk.cluster.server.folder", defaultZooKeeperServePath);
        return hdfsZookeeperServerPath;
    }

    public void postApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        if (this.isNeedStartZookeeper) {
            try {
                this.fileSystem.delete(new Path(this.getZookeeperServerFolder(context)), true);
            }
            catch (IOException e) {
                throw new GuaguaRuntimeException((Throwable)e);
            }
        }
    }

    private String startZookeeperServer(String localHostName) {
        int embedZkClientPort = 0;
        try {
            embedZkClientPort = ZooKeeperUtils.startEmbedZooKeeper();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ZooKeeperUtils.checkIfEmbedZooKeeperStarted((int)embedZkClientPort);
        return localHostName + ":" + embedZkClientPort;
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException((Throwable)e);
        }
    }
}

