/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import ml.shifu.guagua.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMap {
    private static final Logger LOG = LoggerFactory.getLogger(JMap.class);
    public static final String CMD = "jmap";
    public static final String ARGS = "-histo";
    private static int staticProcessId = -1;
    private static final String USER_DIR = "user.dir";

    protected JMap() {
    }

    public static synchronized int getProcessId() {
        if (staticProcessId == -1) {
            String processId = ManagementFactory.getRuntimeMXBean().getName();
            if (processId.contains("@")) {
                processId = processId.substring(0, processId.indexOf("@"));
            }
            staticProcessId = Integer.parseInt(processId);
        }
        return staticProcessId;
    }

    public static void heapHistogramDump(int numLines) {
        JMap.heapHistogramDump(numLines, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void heapHistogramDump(int numLines, PrintStream printStream) {
        BufferedReader in = null;
        try {
            String JAVA_HOME = System.getProperty("java.home");
            if (JAVA_HOME == null) {
                throw new IllegalArgumentException("java.home is not set!");
            }
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(JAVA_HOME + File.separator + ".." + File.separator + "bin" + File.separator + CMD);
            commandList.add(ARGS);
            commandList.add(JMap.getProcessId() + "");
            String workingDir = System.getProperty(USER_DIR, ".");
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            File execDir = new File(workingDir);
            pb.command(commandList);
            pb.directory(execDir);
            pb.redirectErrorStream(true);
            Process jmapProcess = null;
            Class<StreamCollector> clazz = StreamCollector.class;
            synchronized (StreamCollector.class) {
                jmapProcess = pb.start();
                StreamCollector jmapStreamCollector = new StreamCollector(jmapProcess.getInputStream());
                jmapStreamCollector.start();
                // ** MonitorExit[var10_12] (shouldn't be in output)
                Runtime.getRuntime().addShutdownHook(new Thread(new JMapShutdownHook(jmapProcess, jmapStreamCollector, workingDir)));
            }
        }
        catch (IOException e) {
            LOG.error("IOException in dump heap", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error("Error in closing input stream", (Throwable)e);
                }
            }
        }
        {
            return;
        }
    }

    private static class StreamCollector
    extends Thread {
        private static final int LAST_LINES_COUNT = 100;
        private static final Logger LOG = LoggerFactory.getLogger(StreamCollector.class);
        private final BufferedReader bufferedReader;
        private final LinkedList<String> lastLines = new LinkedList();

        public StreamCollector(InputStream is) {
            super(StreamCollector.class.getName());
            this.setDaemon(true);
            InputStreamReader streamReader = new InputStreamReader(is, Charset.defaultCharset());
            this.bufferedReader = new BufferedReader(streamReader);
        }

        @Override
        public void run() {
            this.readLines();
        }

        private synchronized void readLines() {
            try {
                String line;
                while ((line = this.bufferedReader.readLine()) != null) {
                    if (this.lastLines.size() > 100) {
                        this.lastLines.removeFirst();
                    }
                    this.lastLines.add(line);
                    LOG.info("readLines: {}.", (Object)line);
                }
            }
            catch (IOException e) {
                LOG.error("readLines: Ignoring IOException", (Throwable)e);
            }
        }

        public synchronized void dumpLastLines() {
            this.readLines();
            for (String line : this.lastLines) {
                LOG.info(line);
            }
        }

        public void close() {
            try {
                this.bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class JMapShutdownHook
    implements Runnable {
        private Process process;
        private StreamCollector collector;
        private String exeDir;

        public JMapShutdownHook(Process process, StreamCollector collector, String exeDir) {
            this.process = process;
            this.collector = collector;
            this.exeDir = exeDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("start run shutdown hook");
            JMapShutdownHook jMapShutdownHook = this;
            synchronized (jMapShutdownHook) {
                if (this.process != null) {
                    LOG.warn("foeced a shutdown hook kill TomcatProcessSimServer process");
                    this.process.destroy();
                    int returnCode = -1;
                    try {
                        returnCode = this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    LOG.info("TomcatProcessSimServerr process exited with {} (note that 143 typically means killed).", (Object)returnCode);
                }
            }
            this.collector.close();
            FileUtils.deleteQuietly(new File(this.exeDir));
        }
    }
}

