/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;

public class WorkerContext<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable> {
    private int currentIteration;
    private final int totalIteration;
    private MASTER_RESULT lastMasterResult;
    private WORKER_RESULT workerResult;
    private final String appId;
    private final Properties props;
    private final String containerId;
    private final List<GuaguaFileSplit> fileSplits;
    private final String masterResultClassName;
    private final String workerResultClassName;
    private Object attachment;
    private List<WorkerCompletionCallBack<MASTER_RESULT, WORKER_RESULT>> callBackList = new ArrayList<WorkerCompletionCallBack<MASTER_RESULT, WORKER_RESULT>>();

    public WorkerContext(int totalIteration, String appId, Properties props, String containerId, List<GuaguaFileSplit> fileSplits, String masterResultClassName, String workerResultClassName) {
        this.totalIteration = totalIteration;
        this.appId = appId;
        this.props = props;
        this.containerId = containerId;
        this.fileSplits = fileSplits;
        this.masterResultClassName = masterResultClassName;
        this.workerResultClassName = workerResultClassName;
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        this.currentIteration = currentIteration;
    }

    public int getTotalIteration() {
        return this.totalIteration;
    }

    public MASTER_RESULT getLastMasterResult() {
        return this.lastMasterResult;
    }

    public void setLastMasterResult(MASTER_RESULT lastMasterResult) {
        this.lastMasterResult = lastMasterResult;
    }

    void setWorkerResult(WORKER_RESULT workerResult) {
        this.workerResult = workerResult;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public List<GuaguaFileSplit> getFileSplits() {
        return this.fileSplits;
    }

    public Properties getProps() {
        return this.props;
    }

    public WORKER_RESULT getWorkerResult() {
        return this.workerResult;
    }

    public String getWorkerResultClassName() {
        return this.workerResultClassName;
    }

    public String getMasterResultClassName() {
        return this.masterResultClassName;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public boolean isFirstIteration() {
        return this.getCurrentIteration() == 1;
    }

    public boolean isInitIteration() {
        return this.getCurrentIteration() == 0;
    }

    public void addCompletionCallBack(WorkerCompletionCallBack<MASTER_RESULT, WORKER_RESULT> callback) {
        this.callBackList.add(callback);
    }

    public List<WorkerCompletionCallBack<MASTER_RESULT, WORKER_RESULT>> getCallBackList() {
        return this.callBackList;
    }

    public String toString() {
        return String.format("WorkerContext [currentIteration=%s, totalIteration=%s, lastMasterResult=%s, workerResult=%s, appId=%s, containerId=%s, fileSplits=%s, masterResultClassName=%s, workerResultClassName=%s]", this.currentIteration, this.totalIteration, this.lastMasterResult, this.workerResult, this.appId, this.containerId, this.fileSplits, this.masterResultClassName, this.workerResultClassName);
    }

    public static interface WorkerCompletionCallBack<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable> {
        public void callback(WorkerContext<MASTER_RESULT, WORKER_RESULT> var1);
    }
}

