/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic;

import org.encog.ml.MLContext;
import org.encog.ml.genetic.crossover.Crossover;
import org.encog.ml.genetic.genome.CalculateGenomeScore;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.genome.GenomeComparator;
import org.encog.ml.genetic.mutate.Mutate;
import org.encog.ml.genetic.population.Population;
import org.encog.ml.genetic.species.Species;
import org.encog.util.concurrency.MultiThreadable;

public abstract class GeneticAlgorithm
implements MultiThreadable {
    private int threadCount;
    private CalculateGenomeScore calculateScore;
    private GenomeComparator comparator;
    private Crossover crossover;
    private double matingPopulation;
    private Mutate mutate;
    private double mutationPercent;
    private double percentToMate;
    private Population population;
    private boolean multiThreaded = true;

    public final void addSpeciesMember(Species species, Genome genome) {
        if (this.getComparator().isBetterThan(genome.getScore(), species.getBestScore())) {
            species.setBestScore(genome.getScore());
            species.setGensNoImprovement(0);
            species.setLeader(genome);
        }
        species.getMembers().add(genome);
    }

    public final void calculateScore(Genome g) {
        if (g.getOrganism() instanceof MLContext) {
            ((MLContext)g.getOrganism()).clearContext();
        }
        double score = this.calculateScore.calculateScore(g);
        g.setScore(score);
    }

    public final CalculateGenomeScore getCalculateScore() {
        return this.calculateScore;
    }

    public final GenomeComparator getComparator() {
        return this.comparator;
    }

    public final Crossover getCrossover() {
        return this.crossover;
    }

    public final double getMatingPopulation() {
        return this.matingPopulation;
    }

    public final Mutate getMutate() {
        return this.mutate;
    }

    public final double getMutationPercent() {
        return this.mutationPercent;
    }

    public final double getPercentToMate() {
        return this.percentToMate;
    }

    public final Population getPopulation() {
        return this.population;
    }

    public final void setCalculateScore(CalculateGenomeScore theCalculateScore) {
        this.calculateScore = theCalculateScore;
    }

    public final void setComparator(GenomeComparator theComparator) {
        this.comparator = theComparator;
    }

    public final void setCrossover(Crossover theCrossover) {
        this.crossover = theCrossover;
    }

    public final void setMatingPopulation(double theMatingPopulation) {
        this.matingPopulation = theMatingPopulation;
    }

    public final void setMutate(Mutate theMutate) {
        this.mutate = theMutate;
    }

    public final void setMutationPercent(double theMutationPercent) {
        this.mutationPercent = theMutationPercent;
    }

    public final void setPercentToMate(double thePercentToMate) {
        this.percentToMate = thePercentToMate;
    }

    public final void setPopulation(Population thePopulation) {
        this.population = thePopulation;
    }

    public abstract void iteration();

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.threadCount = numThreads;
    }
}

