/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.art;

import org.encog.mathutil.matrices.Matrix;
import org.encog.ml.MLClassification;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.specific.BiPolarNeuralData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.art.ART;

public class ART1
extends ART
implements MLResettable,
MLClassification {
    private static final long serialVersionUID = 1L;
    private int winner;
    private double a1 = 1.0;
    private double b1 = 1.5;
    private double c1 = 5.0;
    private double d1 = 0.9;
    private double l = 3.0;
    private double vigilance = 0.9;
    private transient boolean[] inhibitF2;
    private int noWinner;
    private BiPolarNeuralData outputF1;
    private BiPolarNeuralData outputF2;
    private int f1Count;
    private int f2Count;
    private Matrix weightsF1toF2;
    private Matrix weightsF2toF1;

    public ART1() {
    }

    public ART1(int theF1Count, int theF2Count) {
        this.f1Count = theF1Count;
        this.f2Count = theF2Count;
        this.weightsF1toF2 = new Matrix(this.f1Count, this.f2Count);
        this.weightsF2toF1 = new Matrix(this.f2Count, this.f1Count);
        this.inhibitF2 = new boolean[this.f2Count];
        this.outputF1 = new BiPolarNeuralData(this.f1Count);
        this.outputF2 = new BiPolarNeuralData(this.f2Count);
        this.noWinner = this.f2Count;
        this.reset();
    }

    public final void adjustWeights() {
        for (int i = 0; i < this.f1Count; ++i) {
            if (this.outputF1.getBoolean(i)) {
                double magnitudeInput = this.magnitude(this.outputF1);
                this.weightsF1toF2.set(i, this.winner, 1.0);
                this.weightsF2toF1.set(this.winner, i, this.l / (this.l - 1.0 + magnitudeInput));
                continue;
            }
            this.weightsF1toF2.set(i, this.winner, 0.0);
            this.weightsF2toF1.set(this.winner, i, 0.0);
        }
    }

    @Override
    public final int classify(MLData input) {
        BiPolarNeuralData input2 = new BiPolarNeuralData(this.f1Count);
        BiPolarNeuralData output = new BiPolarNeuralData(this.f2Count);
        if (input.size() != input2.size()) {
            throw new NeuralNetworkError("Input array size does not match.");
        }
        for (int i = 0; i < input2.size(); ++i) {
            input2.setData(i, input.getData(i) > 0.0);
        }
        this.compute(input2, output);
        if (this.hasWinner()) {
            return this.winner;
        }
        return -1;
    }

    public final void compute(BiPolarNeuralData input, BiPolarNeuralData output) {
        for (int i = 0; i < this.f2Count; ++i) {
            this.inhibitF2[i] = false;
        }
        boolean resonance = false;
        boolean exhausted = false;
        do {
            this.setInput(input);
            this.computeF2();
            this.getOutput(output);
            if (this.winner != this.noWinner) {
                this.computeF1(input);
                double magnitudeInput1 = this.magnitude(input);
                double magnitudeInput2 = this.magnitude(this.outputF1);
                if (magnitudeInput2 / magnitudeInput1 < this.vigilance) {
                    this.inhibitF2[this.winner] = true;
                    continue;
                }
                resonance = true;
                continue;
            }
            exhausted = true;
        } while (!resonance && !exhausted);
        if (resonance) {
            this.adjustWeights();
        }
    }

    public final MLData compute(MLData input) {
        if (!(input instanceof BiPolarNeuralData)) {
            throw new NeuralNetworkError("Input to ART1 logic network must be BiPolarNeuralData.");
        }
        BiPolarNeuralData output = new BiPolarNeuralData(this.f1Count);
        this.compute((BiPolarNeuralData)input, output);
        return output;
    }

    private void computeF1(BiPolarNeuralData input) {
        for (int i = 0; i < this.f1Count; ++i) {
            double sum = this.weightsF1toF2.get(i, this.winner) * (double)(this.outputF2.getBoolean(this.winner) ? 1 : 0);
            double activation = ((double)(input.getBoolean(i) ? 1 : 0) + this.d1 * sum - this.b1) / (1.0 + this.a1 * ((double)(input.getBoolean(i) ? 1 : 0) + this.d1 * sum) + this.c1);
            this.outputF1.setData(i, activation > 0.0);
        }
    }

    private void computeF2() {
        double maxOut = Double.NEGATIVE_INFINITY;
        this.winner = this.noWinner;
        for (int i = 0; i < this.f2Count; ++i) {
            if (!this.inhibitF2[i]) {
                double sum = 0.0;
                for (int j = 0; j < this.f1Count; ++j) {
                    sum += this.weightsF2toF1.get(i, j) * (double)(this.outputF1.getBoolean(j) ? 1 : 0);
                }
                if (sum > maxOut) {
                    maxOut = sum;
                    this.winner = i;
                }
            }
            this.outputF2.setData(i, false);
        }
        if (this.winner != this.noWinner) {
            this.outputF2.setData(this.winner, true);
        }
    }

    public final double getA1() {
        return this.a1;
    }

    public final double getB1() {
        return this.b1;
    }

    public final double getC1() {
        return this.c1;
    }

    public final double getD1() {
        return this.d1;
    }

    public final int getF1Count() {
        return this.f1Count;
    }

    public final int getF2Count() {
        return this.f2Count;
    }

    @Override
    public final int getInputCount() {
        return this.f1Count;
    }

    public final double getL() {
        return this.l;
    }

    public final int getNoWinner() {
        return this.noWinner;
    }

    private void getOutput(BiPolarNeuralData output) {
        for (int i = 0; i < this.f2Count; ++i) {
            output.setData(i, this.outputF2.getBoolean(i));
        }
    }

    @Override
    public final int getOutputCount() {
        return this.f2Count;
    }

    public final double getVigilance() {
        return this.vigilance;
    }

    public final Matrix getWeightsF1toF2() {
        return this.weightsF1toF2;
    }

    public final Matrix getWeightsF2toF1() {
        return this.weightsF2toF1;
    }

    public final int getWinner() {
        return this.winner;
    }

    public final boolean hasWinner() {
        return this.winner != this.noWinner;
    }

    public final double magnitude(BiPolarNeuralData input) {
        double result = 0.0;
        for (int i = 0; i < this.f1Count; ++i) {
            result += input.getBoolean(i) ? 1.0 : 0.0;
        }
        return result;
    }

    @Override
    public final void reset() {
        this.reset(0);
    }

    @Override
    public final void reset(int seed) {
        for (int i = 0; i < this.f1Count; ++i) {
            for (int j = 0; j < this.f2Count; ++j) {
                this.weightsF1toF2.set(i, j, (this.b1 - 1.0) / this.d1 + 0.2);
                this.weightsF2toF1.set(j, i, this.l / (this.l - 1.0 + (double)this.f1Count) - 0.1);
            }
        }
    }

    public final void setA1(double theA1) {
        this.a1 = theA1;
    }

    public final void setB1(double theB1) {
        this.b1 = theB1;
    }

    public final void setC1(double theC1) {
        this.c1 = theC1;
    }

    public final void setD1(double theD1) {
        this.d1 = theD1;
    }

    public final void setF1Count(int i) {
        this.f1Count = i;
        this.outputF1 = new BiPolarNeuralData(this.f1Count);
    }

    public final void setF2Count(int i) {
        this.f2Count = i;
        this.inhibitF2 = new boolean[this.f2Count];
        this.outputF2 = new BiPolarNeuralData(this.f2Count);
    }

    private void setInput(BiPolarNeuralData input) {
        for (int i = 0; i < this.f1Count; ++i) {
            double activation = (double)(input.getBoolean(i) ? 1 : 0) / (1.0 + this.a1 * ((double)(input.getBoolean(i) ? 1 : 0) + this.b1) + this.c1);
            this.outputF1.setData(i, activation > 0.0);
        }
    }

    public final void setL(double theL) {
        this.l = theL;
    }

    public final void setNoWinner(int i) {
        this.noWinner = i;
    }

    public final void setVigilance(double theVigilance) {
        this.vigilance = theVigilance;
    }

    public final void setWeightsF1toF2(Matrix matrix) {
        this.weightsF1toF2 = matrix;
    }

    public final void setWeightsF2toF1(Matrix matrix) {
        this.weightsF2toF1 = matrix;
    }
}

