/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.cpn.CPN;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;

public class CPNPattern
implements NeuralNetworkPattern {
    public static final String TAG_INSTAR = "INSTAR";
    public static final String TAG_OUTSTAR = "OUTSTAR";
    private int instarCount;
    private int outstarCount;
    private int inputCount;

    @Override
    public final void addHiddenLayer(int count) {
        throw new PatternError("A CPN already has a predefined hidden layer.  No additionalspecification is needed.");
    }

    @Override
    public final void clear() {
        this.inputCount = 0;
        this.instarCount = 0;
        this.outstarCount = 0;
    }

    @Override
    public final MLMethod generate() {
        return new CPN(this.inputCount, this.instarCount, this.outstarCount, 1);
    }

    @Override
    public final void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("A CPN network will use the BiPolar & competitive activation functions, no activation function needs to be specified.");
    }

    @Override
    public final void setInputNeurons(int count) {
        this.inputCount = count;
    }

    public final void setInstarCount(int instarCount) {
        this.instarCount = instarCount;
    }

    @Override
    public final void setOutputNeurons(int count) {
        this.outstarCount = count;
    }

    public final void setOutstarCount(int outstarCount) {
        this.outstarCount = outstarCount;
    }
}

