/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import ml.shifu.guagua.hadoop.io.GuaguaWritableAdapter;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.GuaguaRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.LineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaLineRecordReader
implements GuaguaRecordReader<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<Text>> {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaLineRecordReader.class);
    private CompressionCodecFactory compressionCodecs = null;
    private long start;
    private long pos;
    private long end;
    private LineReader in;
    private int maxLineLength;
    private GuaguaWritableAdapter<LongWritable> key = null;
    private GuaguaWritableAdapter<Text> value = null;
    private Configuration conf;

    public GuaguaLineRecordReader() {
        this.conf = new Configuration();
    }

    public GuaguaLineRecordReader(GuaguaFileSplit split) throws IOException {
        this(new Configuration(), split);
    }

    public GuaguaLineRecordReader(Configuration conf, GuaguaFileSplit split) throws IOException {
        this.conf = conf;
        this.initialize(split);
    }

    public void initialize(GuaguaFileSplit split) throws IOException {
        this.maxLineLength = this.conf.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        int ioBufferSize = this.conf.getInt("io.file.buffer.size", 65536);
        this.start = split.getOffset();
        this.end = this.start + split.getLength();
        Path file = new Path(split.getPath());
        this.compressionCodecs = new CompressionCodecFactory(this.conf);
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        FileSystem fs = file.getFileSystem(new Configuration());
        FSDataInputStream fileIn = fs.open(file);
        boolean skipFirstLine = false;
        if (codec != null) {
            this.in = new LineReader((InputStream)codec.createInputStream((InputStream)fileIn), 65536);
            this.end = Long.MAX_VALUE;
        } else {
            if (this.start != 0L) {
                skipFirstLine = true;
                --this.start;
                fileIn.seek(this.start);
            }
            this.in = new LineReader((InputStream)fileIn, ioBufferSize);
        }
        if (skipFirstLine) {
            this.start += (long)this.in.readLine(new Text(), 0, (int)Math.min(Integer.MAX_VALUE, this.end - this.start));
        }
        this.pos = this.start;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.key == null) {
            this.key = new GuaguaWritableAdapter<LongWritable>(new LongWritable());
        }
        this.key.getWritable().set(this.pos);
        if (this.value == null) {
            this.value = new GuaguaWritableAdapter<Text>(new Text());
        }
        int newSize = 0;
        while (this.pos < this.end && (newSize = this.in.readLine(this.value.getWritable(), this.maxLineLength, Math.max((int)Math.min(Integer.MAX_VALUE, this.end - this.pos), this.maxLineLength))) != 0) {
            this.pos += (long)newSize;
            if (newSize < this.maxLineLength) break;
            LOG.info("Skipped line of size {} at pos {}", (Object)newSize, (Object)(this.pos - (long)newSize));
        }
        if (newSize == 0) {
            this.key = null;
            this.value = null;
            return false;
        }
        return true;
    }

    public GuaguaWritableAdapter<LongWritable> getCurrentKey() {
        return this.key;
    }

    public GuaguaWritableAdapter<Text> getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

