/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.example.sum;

import ml.shifu.guagua.ComputableMonitor;
import ml.shifu.guagua.hadoop.io.GuaguaWritableAdapter;
import ml.shifu.guagua.master.MasterComputable;
import ml.shifu.guagua.master.MasterContext;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ComputableMonitor
public class SumMaster
implements MasterComputable<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>> {
    private static final Logger LOG = LoggerFactory.getLogger(SumMaster.class);

    public GuaguaWritableAdapter<LongWritable> compute(MasterContext<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>> context) {
        long sum = 0L;
        if (context.getWorkerResults() == null) {
            LOG.info("Master accumulates worker results with null or empty.");
            return null;
        }
        for (GuaguaWritableAdapter longWritable : context.getWorkerResults()) {
            if (longWritable == null) continue;
            sum += ((LongWritable)longWritable.getWritable()).get();
        }
        LOG.info("master:{}", (Object)sum);
        GuaguaWritableAdapter result = new GuaguaWritableAdapter((Writable)new LongWritable(sum));
        if (sum > 1000000L) {
            result.setHalt(true);
        }
        return result;
    }
}

