/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn;

import com.google.common.collect.Maps;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.hadoop.io.GuaguaInputSplit;
import ml.shifu.guagua.yarn.GuaguaIterationStatus;
import ml.shifu.guagua.yarn.GuaguaYarnTask;
import ml.shifu.guagua.yarn.util.GsonUtils;
import ml.shifu.guagua.yarn.util.YarnUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.serialization.ClassResolvers;
import org.jboss.netty.handler.codec.serialization.ObjectDecoder;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaAppMaster {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaAppMaster.class);
    private static final int YARN_ABORT_EXIT_STATUS = -100;
    private static final int YARN_SUCCESS_EXIT_STATUS = 0;
    private static final int SLEEP_BETWEEN_HEARTBEATS_MSECS = 900;
    private ContainerId masterContainerId;
    private ApplicationAttemptId appAttemptId;
    private volatile boolean done;
    private Configuration yarnConf;
    private AtomicInteger completedCount;
    private AtomicInteger failedCount;
    private AtomicInteger allocatedCount;
    private AtomicInteger successfulCount;
    private int containersToLaunch;
    private ExecutorService executor;
    private ExecutorService taskTimeoutExecutor;
    private long taskTimeOut = 600000L;
    private int heapPerContainer;
    private AMRMClientAsync<AMRMClient.ContainerRequest> amRmClient;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    private static Map<String, LocalResource> localResources;
    private String appMasterHostname;
    private int appMasterRpcPort = 1234;
    private String appMasterTrackingUrl = "";
    private String containerArgs;
    private List<InputSplit> inputSplits;
    private ApplicationId appId;
    private Map<Integer, List<Container>> partitionContainerMap;
    private Map<String, Integer> containerPartitionMap;
    private Map<Integer, PartitionStatus> partitionStatusMap;
    private List<Integer> failedPartitions;
    private AtomicInteger partitionIndex;
    private int maxContainerAttempts;
    private int totalIterations;
    private ByteBuffer allTokens;
    private int rpcPort = 12345;
    private String rpcHostName;
    private static final Object LOCK;
    private Map<Integer, GuaguaIterationStatus> partitionProgress;
    private ServerBootstrap rpcServer;

    public GuaguaAppMaster(ContainerId cId, ApplicationAttemptId aId, Configuration conf) {
        try {
            this.rpcHostName = this.appMasterHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Error in getting local host name.", (Throwable)e);
        }
        this.masterContainerId = cId;
        this.appAttemptId = aId;
        this.appId = this.getAppAttemptId().getApplicationId();
        this.yarnConf = conf;
        this.completedCount = new AtomicInteger(0);
        this.failedCount = new AtomicInteger(0);
        this.allocatedCount = new AtomicInteger(0);
        this.successfulCount = new AtomicInteger(0);
        this.partitionContainerMap = new ConcurrentHashMap<Integer, List<Container>>();
        this.containerPartitionMap = new ConcurrentHashMap<String, Integer>();
        this.partitionStatusMap = new ConcurrentHashMap<Integer, PartitionStatus>();
        this.partitionIndex = new AtomicInteger(0);
        this.failedPartitions = new CopyOnWriteArrayList<Integer>();
        this.maxContainerAttempts = this.getYarnConf().getInt("guagua.yarn.max.container.attempts", 4);
        this.heapPerContainer = this.getYarnConf().getInt("guagua.child.memory", 1024);
        this.totalIterations = this.getYarnConf().getInt("guagua.iteration.count", 1);
        String containerArgs = this.getYarnConf().get("guagua.yarn.container.args");
        containerArgs = containerArgs == null ? "-server -XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70" : "-server -XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70 " + containerArgs;
        this.containerArgs = containerArgs;
        this.rpcPort = this.getYarnConf().getInt("guagua.yarn.status.rpc.port", 12345);
        this.partitionProgress = new ConcurrentHashMap<Integer, GuaguaIterationStatus>();
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.taskTimeoutExecutor = Executors.newSingleThreadExecutor();
        this.taskTimeOut = this.getYarnConf().getLong("guagua.task.timeout", 600000L);
        LOG.info("{}:{}", (Object)this.taskTimeOut, (Object)600000L);
        LOG.info("GuaguaAppMaster  for ContainerId {} ApplicationAttemptId {}", (Object)cId, (Object)aId);
    }

    public boolean run() throws YarnException, IOException {
        boolean success = false;
        try {
            this.prepareInputSplits();
            this.getAllTokens();
            this.registerRMCallBackHandler();
            this.registerNMCallbackHandler();
            this.registerAMToRM();
            this.startRPCServer();
            this.startTaskTimeoutExecutor();
            this.madeAllContainerRequestToRM();
            LOG.info("Wait to finish ..");
            while (!this.isDone()) {
                try {
                    Thread.sleep(900L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info("Done {}", (Object)this.isDone());
        }
        catch (Throwable t) {
            LOG.error("Error in AppMaster run.", t);
            throw new GuaguaRuntimeException(t);
        }
        finally {
            this.shutdown();
            success = this.finish();
        }
        return success;
    }

    private void startTaskTimeoutExecutor() {
        this.taskTimeoutExecutor.submit(new Runnable(){

            @Override
            public void run() {
                block2: while (true) {
                    try {
                        Thread.sleep(GuaguaAppMaster.this.taskTimeOut);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    LOG.debug(GuaguaAppMaster.this.partitionProgress.toString());
                    Iterator i$ = GuaguaAppMaster.this.partitionProgress.entrySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        Map.Entry entry = i$.next();
                        GuaguaIterationStatus status = (GuaguaIterationStatus)entry.getValue();
                        if (status.getTime() == 0L || status.getCurrentIteration() == 1 || System.currentTimeMillis() - status.getTime() <= GuaguaAppMaster.this.taskTimeOut) continue;
                        List containers = (List)GuaguaAppMaster.this.partitionContainerMap.get(entry.getKey());
                        Container container = (Container)containers.get(containers.size() - 1);
                        LOG.info("Container {} is timeout with timeout period {}, will be killed by node manager {}.", new Object[]{container.getId(), GuaguaAppMaster.this.taskTimeOut, container.getNodeId()});
                        GuaguaAppMaster.this.getNmClientAsync().stopContainerAsync(container.getId(), container.getNodeId());
                    }
                    break;
                }
            }
        });
    }

    protected void shutdown() {
        if (null != this.getExecutor() && !this.getExecutor().isTerminated()) {
            LOG.info("Forcefully terminating executors with done ={}", (Object)this.isDone());
            this.getExecutor().shutdownNow();
        }
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
            this.rpcServer.releaseExternalResources();
        }
        if (this.taskTimeoutExecutor != null) {
            this.taskTimeoutExecutor.shutdownNow();
        }
    }

    private void startRPCServer() {
        this.rpcServer = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newFixedThreadPool(4), (Executor)Executors.newCachedThreadPool(new MasterThreadFactory())));
        this.rpcServer.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new ObjectEncoder(), new ObjectDecoder(ClassResolvers.cacheDisabled((ClassLoader)this.getClass().getClassLoader())), new ServerHandler()});
            }
        });
        this.rpcServer.bind((SocketAddress)new InetSocketAddress(this.rpcPort));
    }

    private void prepareInputSplits() throws IOException {
        this.inputSplits = this.getNewSplits(this.getYarnConf());
        this.setContainersToLaunch(this.inputSplits.size());
        LOG.info("Input split size including master: {}", (Object)this.inputSplits.size());
    }

    public List<InputSplit> getNewSplits(Configuration conf) throws IOException {
        int masters = conf.getInt("guagua.master.number", 1);
        int size = this.getYarnConf().getInt("guagua.worker.number", 0) + masters;
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(size);
        for (int i = 1; i <= size; ++i) {
            newSplits.add(GsonUtils.fromJson(this.getYarnConf().get("guagua.yarn.input.split." + i), GuaguaInputSplit.class));
            this.partitionProgress.put(i, new GuaguaIterationStatus());
        }
        return newSplits;
    }

    private void getAllTokens() throws IOException {
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Token type : {}", (Object)token.getKind());
            }
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
    }

    private void registerRMCallBackHandler() {
        RMCallbackHandler allocListener = new RMCallbackHandler();
        this.setAmRMClient((AMRMClientAsync<AMRMClient.ContainerRequest>)AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)allocListener));
        this.getAmRMClient().init(this.getYarnConf());
        this.getAmRMClient().start();
    }

    private void registerNMCallbackHandler() {
        this.setContainerListener(new NMCallbackHandler());
        this.setNmClientAsync((NMClientAsync)new NMClientAsyncImpl((NMClientAsync.CallbackHandler)this.getContainerListener()));
        this.getNmClientAsync().init(this.getYarnConf());
        this.getNmClientAsync().start();
    }

    private RegisterApplicationMasterResponse registerAMToRM() throws YarnException {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                LOG.info("SECURITY ENABLED ");
            }
            RegisterApplicationMasterResponse response = this.getAmRMClient().registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
            return response;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("GuaguaAppMaster failed to register with RM.", ioe);
        }
    }

    private void madeAllContainerRequestToRM() {
        for (int i = 0; i < this.getContainersToLaunch(); ++i) {
            AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
            this.getAmRMClient().addContainerRequest(containerAsk);
        }
    }

    private void madeOneContainerRequestToRM() {
        AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
        this.getAmRMClient().addContainerRequest(containerAsk);
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM() {
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(0);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(this.getHeapPerContainer());
        capability.setVirtualCores(this.getYarnConf().getInt("guagua.yarn.task.vcores", 1));
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri);
        LOG.info("Requested container ask: {}", (Object)request.toString());
        return request;
    }

    private boolean finish() {
        FinalApplicationStatus appStatus;
        LOG.info("Application completed. Stopping running containers");
        this.getNmClientAsync().stop();
        LOG.info("Application completed. Signalling finish to RM");
        String appMessage = null;
        boolean success = true;
        if (this.getSuccessfulCount().get() == this.getContainersToLaunch()) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            appMessage = String.format("Diagnostics total=%s, completed=%s, failed=%s.", this.getContainersToLaunch(), this.getCompletedCount().get(), this.getFailedCount().get());
            success = false;
        }
        try {
            this.getAmRMClient().unregisterApplicationMaster(appStatus, appMessage, this.appMasterTrackingUrl);
        }
        catch (YarnException ex) {
            LOG.error("Failed to unregister application", (Throwable)ex);
        }
        catch (IOException e) {
            LOG.error("Failed to unregister application", (Throwable)e);
        }
        this.getAmRMClient().stop();
        return success;
    }

    private void startContainerLaunchingThreads(List<Container> allocatedContainers) {
        Map<String, List<Container>> hostContainterMap = this.getHostContainersMap(allocatedContainers);
        int size = allocatedContainers.size();
        while (size > 0) {
            int currentPartition = this.getCurrentPartition();
            if (currentPartition == -1) {
                LOG.warn("Request too many resources. TODO, remove containers no needed.");
                for (Container container : allocatedContainers) {
                    this.getAmRMClient().releaseAssignedContainer(container.getId());
                }
                break;
            }
            Container container = this.getDataLocalityContainer(hostContainterMap, currentPartition);
            if (container == null) {
                container = allocatedContainers.get(0);
            }
            allocatedContainers.remove(container);
            LOG.info("Launching command on a new container., containerId={}, containerNode={}, containerPort={}, containerNodeURI={}, containerResourceMemory={}", new Object[]{container.getId(), container.getNodeId().getHost(), container.getNodeId().getPort(), container.getNodeHttpAddress(), container.getResource().getMemory()});
            List<Container> list = this.partitionContainerMap.get(currentPartition);
            if (list == null) {
                list = new ArrayList<Container>();
            }
            list.add(container);
            this.partitionContainerMap.put(currentPartition, list);
            this.containerPartitionMap.put(container.getId().toString(), currentPartition);
            this.partitionStatusMap.put(currentPartition, PartitionStatus.INIT);
            LaunchContainerRunnable runnableLaunchContainer = new LaunchContainerRunnable(container, this.getContainerListener(), currentPartition);
            this.getExecutor().execute(runnableLaunchContainer);
            size = allocatedContainers.size();
        }
    }

    private Map<String, List<Container>> getHostContainersMap(List<Container> allocatedContainers) {
        HashMap<String, List<Container>> hostContainterMap = new HashMap<String, List<Container>>();
        for (Container container : allocatedContainers) {
            String host = container.getNodeId().getHost();
            ArrayList<Container> containers = (ArrayList<Container>)hostContainterMap.get(host);
            if (containers == null) {
                containers = new ArrayList<Container>();
            }
            containers.add(container);
            hostContainterMap.put(host, containers);
        }
        return hostContainterMap;
    }

    private Container getDataLocalityContainer(Map<String, List<Container>> hostContainterMap, int currentPartition) {
        GuaguaInputSplit inputSplit = (GuaguaInputSplit)this.inputSplits.get(currentPartition - 1);
        String host = null;
        FileSplit[] fileSplits = inputSplit.getFileSplits();
        if (fileSplits != null) {
            try {
                host = fileSplits[0].getLocations()[0];
            }
            catch (Exception mayNotHappen) {
                host = null;
            }
        }
        List<Container> containers = hostContainterMap.get(host);
        Container container = null;
        if (containers != null && !containers.isEmpty()) {
            container = containers.remove(0);
            hostContainterMap.put(host, containers);
            LOG.info("find a container {} with host {} for partition {} and split {}.", new Object[]{container, host, currentPartition, inputSplit});
            return container;
        }
        Set<Map.Entry<String, List<Container>>> entrySet = hostContainterMap.entrySet();
        String firstHost = null;
        List<Container> firstContainers = null;
        for (Map.Entry<String, List<Container>> entry : entrySet) {
            firstHost = entry.getKey();
            firstContainers = entry.getValue();
            if (firstContainers == null || firstContainers.isEmpty()) continue;
            container = firstContainers.remove(0);
            break;
        }
        hostContainterMap.put(firstHost, firstContainers);
        LOG.info("find a container {} with host {} for partition {} and split {}.", new Object[]{container, host, currentPartition, inputSplit});
        return container;
    }

    private int getCurrentPartition() {
        LOG.info("failed container request size:{} {}", (Object)this.failedPartitions.size(), this.failedPartitions);
        Iterator<Integer> it = this.failedPartitions.iterator();
        int currentPartition = 0;
        if (it.hasNext()) {
            currentPartition = it.next();
            this.failedPartitions.remove((Object)currentPartition);
            LOG.info("failed container request size after remove:{} {}", (Object)this.failedPartitions.size(), this.failedPartitions);
        } else {
            LOG.info("partitionIndex{} containersToLaunch {}", (Object)this.partitionIndex.get(), (Object)this.containersToLaunch);
            if (this.partitionIndex.get() >= this.containersToLaunch) {
                return -1;
            }
            currentPartition = this.partitionIndex.addAndGet(1);
        }
        return currentPartition;
    }

    private synchronized Map<String, LocalResource> getTaskResourceMap() {
        if (null == localResources) {
            localResources = Maps.newHashMap();
            try {
                localResources = YarnUtils.getLocalResourceMap(this.getYarnConf(), this.getAppId());
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not configure the container launch context for GuaguaYarnTask.", ioe);
            }
        }
        return localResources;
    }

    public ContainerId getContainerId() {
        return this.masterContainerId;
    }

    public void setContainerId(ContainerId containerId) {
        this.masterContainerId = containerId;
    }

    public ApplicationAttemptId getAppAttemptId() {
        return this.appAttemptId;
    }

    public void setAppAttemptId(ApplicationAttemptId appAttemptId) {
        this.appAttemptId = appAttemptId;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public Configuration getYarnConf() {
        return this.yarnConf;
    }

    public void setYarnConf(YarnConfiguration yarnConf) {
        this.yarnConf = yarnConf;
    }

    public AtomicInteger getCompletedCount() {
        return this.completedCount;
    }

    public void setCompletedCount(AtomicInteger completedCount) {
        this.completedCount = completedCount;
    }

    public AtomicInteger getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(AtomicInteger failedCount) {
        this.failedCount = failedCount;
    }

    public AtomicInteger getAllocatedCount() {
        return this.allocatedCount;
    }

    public void setAllocatedCount(AtomicInteger allocatedCount) {
        this.allocatedCount = allocatedCount;
    }

    public AtomicInteger getSuccessfulCount() {
        return this.successfulCount;
    }

    public void setSuccessfulCount(AtomicInteger successfulCount) {
        this.successfulCount = successfulCount;
    }

    public int getContainersToLaunch() {
        return this.containersToLaunch;
    }

    public void setContainersToLaunch(int containersToLaunch) {
        this.containersToLaunch = containersToLaunch;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public int getHeapPerContainer() {
        return this.heapPerContainer;
    }

    public void setHeapPerContainer(int heapPerContainer) {
        this.heapPerContainer = heapPerContainer;
    }

    public AMRMClientAsync<AMRMClient.ContainerRequest> getAmRMClient() {
        return this.amRmClient;
    }

    public void setAmRMClient(AMRMClientAsync<AMRMClient.ContainerRequest> amRMClient) {
        this.amRmClient = amRMClient;
    }

    public NMClientAsync getNmClientAsync() {
        return this.nmClientAsync;
    }

    public void setNmClientAsync(NMClientAsync nmClientAsync) {
        this.nmClientAsync = nmClientAsync;
    }

    public NMCallbackHandler getContainerListener() {
        return this.containerListener;
    }

    public void setContainerListener(NMCallbackHandler containerListener) {
        this.containerListener = containerListener;
    }

    public String getContainerArgs() {
        return this.containerArgs;
    }

    public void setContainerArgs(String containerArgs) {
        this.containerArgs = containerArgs;
    }

    public ApplicationId getAppId() {
        return this.appId;
    }

    public void setAppId(ApplicationId appId) {
        this.appId = appId;
    }

    public static void main(String[] args) {
        LOG.info("Starting GuaguaAppMaster. ");
        String containerIdString = System.getenv().get(ApplicationConstants.Environment.CONTAINER_ID.name());
        if (containerIdString == null) {
            throw new IllegalArgumentException("ContainerId not found in env vars.");
        }
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdString);
        ApplicationAttemptId appAttemptId = containerId.getApplicationAttemptId();
        YarnConfiguration conf = new YarnConfiguration();
        String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
        conf.set("mapreduce.job.user.name", jobUserName);
        try {
            UserGroupInformation.setConfiguration((Configuration)conf);
            Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
            LOG.info("Executing with tokens:");
            for (Token token : credentials.getAllTokens()) {
                LOG.info(token.toString());
            }
            UserGroupInformation appMasterUgi = UserGroupInformation.createRemoteUser((String)jobUserName);
            appMasterUgi.addCredentials(credentials);
            Iterator iter = credentials.getAllTokens().iterator();
            while (iter.hasNext()) {
                Token token = (Token)iter.next();
                if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
                iter.remove();
            }
            final GuaguaAppMaster appMaster = new GuaguaAppMaster(containerId, appAttemptId, (Configuration)conf);
            appMasterUgi.doAs((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    boolean result = false;
                    try {
                        result = appMaster.run();
                    }
                    catch (Throwable t) {
                        LOG.error("GuaguaAppMaster caught a top-level exception in main.", t);
                        System.exit(1);
                    }
                    if (result) {
                        LOG.info("Guagua Application Master completed successfully. exiting");
                        System.exit(0);
                    } else {
                        LOG.info("Guagua Application Master failed. exiting");
                        System.exit(2);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            LOG.error("GuaguaAppMaster caught a top-level exception in main.", t);
            System.exit(1);
        }
    }

    static {
        LOCK = new Object();
        Configuration.addDefaultResource((String)"guagua-conf.xml");
    }

    private class NMCallbackHandler
    implements NMClientAsync.CallbackHandler {
        private ConcurrentMap<ContainerId, Container> containers = new ConcurrentHashMap<ContainerId, Container>();

        private NMCallbackHandler() {
        }

        public void addContainer(ContainerId containerId, Container container) {
            this.containers.putIfAbsent(containerId, container);
        }

        public void onContainerStopped(ContainerId containerId) {
            LOG.info("Succeeded to stop Container {}", (Object)containerId);
            this.containers.remove(containerId);
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            LOG.info("Container Status: id={}, status={}", (Object)containerId, (Object)containerStatus);
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            LOG.info("Succeeded to start Container {}", (Object)containerId);
            Container container = (Container)this.containers.get(containerId);
            if (container != null) {
                GuaguaAppMaster.this.getNmClientAsync().getContainerStatusAsync(containerId, container.getNodeId());
            }
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            LOG.error(String.format("Failed to start Container %s", containerId), t);
            this.containers.remove(containerId);
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            LOG.error(String.format("Failed to query the status of Container %s", containerId), t);
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            LOG.error(String.format("Failed to stop Container %s", containerId), t);
            this.containers.remove(containerId);
        }
    }

    private class LaunchContainerRunnable
    implements Runnable {
        private Container container;
        private NMCallbackHandler containerListener;
        private final int partition;

        public LaunchContainerRunnable(Container container, NMCallbackHandler containerListener, int partition) {
            this.container = container;
            this.containerListener = containerListener;
            this.partition = partition;
        }

        @Override
        public void run() {
            ContainerLaunchContext ctx = this.buildContainerLaunchContext();
            this.containerListener.addContainer(this.container.getId(), this.container);
            GuaguaAppMaster.this.getNmClientAsync().startContainerAsync(this.container, ctx);
        }

        private ContainerLaunchContext buildContainerLaunchContext() {
            LOG.info("Setting up container launch container for containerid={}", (Object)this.container.getId());
            ContainerLaunchContext launchContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            List<String> commands = this.generateShellExecCommand();
            LOG.info("Conatain launch Commands :{}" + commands);
            launchContext.setCommands(commands);
            launchContext.setTokens(GuaguaAppMaster.this.allTokens.slice());
            this.buildEnvironment(launchContext);
            launchContext.setLocalResources(GuaguaAppMaster.this.getTaskResourceMap());
            return launchContext;
        }

        private List<String> generateShellExecCommand() {
            String programArgs = new StringBuilder(300).append(GuaguaAppMaster.this.getAppAttemptId().getApplicationId().getClusterTimestamp()).append(" ").append(GuaguaAppMaster.this.getAppAttemptId().getApplicationId().getId()).append(" ").append(this.container.getId().getId()).append(" ").append(GuaguaAppMaster.this.getAppAttemptId().getAttemptId()).append(" ").append(this.partition).append(" ").append(GuaguaAppMaster.this.rpcHostName).append(" ").append(GuaguaAppMaster.this.rpcPort).toString();
            return YarnUtils.getCommand(GuaguaYarnTask.class.getName(), GuaguaAppMaster.this.containerArgs, programArgs, GuaguaAppMaster.this.getHeapPerContainer() + "");
        }

        private void buildEnvironment(ContainerLaunchContext launchContext) {
            HashMap classPathForEnv = Maps.newHashMap();
            YarnUtils.addLocalClasspathToEnv(classPathForEnv, GuaguaAppMaster.this.getYarnConf());
            launchContext.setEnvironment((Map)classPathForEnv);
        }
    }

    private class RMCallbackHandler
    implements AMRMClientAsync.CallbackHandler {
        private RMCallbackHandler() {
        }

        public void onContainersCompleted(List<ContainerStatus> completedContainers) {
            LOG.info("Got response from RM for container ask, completedCnt={}", (Object)completedContainers.size());
            for (ContainerStatus containerStatus : completedContainers) {
                LOG.info("Got container status for containerID={}, state={}, exitStatus={}, diagnostics={}.", new Object[]{containerStatus.getContainerId(), containerStatus.getState(), containerStatus.getExitStatus(), containerStatus.getDiagnostics()});
                if (!GuaguaAppMaster.this.containerPartitionMap.containsKey(containerStatus.getContainerId().toString())) {
                    GuaguaAppMaster.this.getCompletedCount().incrementAndGet();
                    LOG.info("Why such container {} is started, no partition. Exited with status:{}", (Object)containerStatus.getContainerId(), (Object)containerStatus.getExitStatus());
                    continue;
                }
                int partition = (Integer)GuaguaAppMaster.this.containerPartitionMap.get(containerStatus.getContainerId().toString());
                if (((List)GuaguaAppMaster.this.partitionContainerMap.get(partition)).size() >= GuaguaAppMaster.this.maxContainerAttempts) {
                    GuaguaAppMaster.this.setDone(true);
                    LOG.info("One partition {} has more than max attempt {} ", (Object)partition, (Object)GuaguaAppMaster.this.maxContainerAttempts);
                    return;
                }
                switch (containerStatus.getExitStatus()) {
                    case 0: {
                        GuaguaAppMaster.this.partitionStatusMap.put(partition, PartitionStatus.SUCCESSFUL);
                        GuaguaAppMaster.this.getSuccessfulCount().incrementAndGet();
                        break;
                    }
                    case -100: {
                        LOG.info("YARN_ABORT_EXIT_STATUS: Container id {} exits with {}", (Object)containerStatus.getContainerId(), (Object)-100);
                        break;
                    }
                    default: {
                        LOG.info("default: Container id {} exits with {}", (Object)containerStatus.getContainerId(), (Object)containerStatus.getExitStatus());
                        GuaguaAppMaster.this.partitionStatusMap.put(partition, PartitionStatus.FAILED);
                        GuaguaAppMaster.this.failedPartitions.add(partition);
                        GuaguaAppMaster.this.madeOneContainerRequestToRM();
                        GuaguaAppMaster.this.getFailedCount().incrementAndGet();
                    }
                }
                GuaguaAppMaster.this.getCompletedCount().incrementAndGet();
            }
            if (GuaguaAppMaster.this.getSuccessfulCount().get() == GuaguaAppMaster.this.getContainersToLaunch()) {
                GuaguaAppMaster.this.setDone(true);
                LOG.info("All container compeleted. done = {} ", (Object)GuaguaAppMaster.this.isDone());
            } else {
                LOG.info("After completion of one conatiner. current status is: completedCount:{} containersToLaunch:{} successfulCount:{} failedCount:{}.", new Object[]{GuaguaAppMaster.this.getCompletedCount().get(), GuaguaAppMaster.this.getContainersToLaunch(), GuaguaAppMaster.this.getSuccessfulCount().get(), GuaguaAppMaster.this.getFailedCount().get()});
            }
        }

        public void onContainersAllocated(List<Container> allocatedContainers) {
            LOG.info("Got response from RM for container ask, allocatedCnt={}", (Object)allocatedContainers.size());
            GuaguaAppMaster.this.getAllocatedCount().addAndGet(allocatedContainers.size());
            LOG.info("Total allocated # of container so far {} : allocated out of required {}.", (Object)GuaguaAppMaster.this.getAllocatedCount().get(), (Object)GuaguaAppMaster.this.getContainersToLaunch());
            GuaguaAppMaster.this.startContainerLaunchingThreads(allocatedContainers);
        }

        public void onShutdownRequest() {
            GuaguaAppMaster.this.setDone(true);
            GuaguaAppMaster.this.getAmRMClient().stop();
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getProgress() {
            int sum = 0;
            int totalSum = 0;
            Object object = LOCK;
            synchronized (object) {
                for (Map.Entry entry : GuaguaAppMaster.this.partitionProgress.entrySet()) {
                    sum += ((GuaguaIterationStatus)entry.getValue()).getCurrentIteration();
                    totalSum += GuaguaAppMaster.this.totalIterations;
                }
                return (float)sum * 1.0f / (float)totalSum;
            }
        }

        public void onError(Throwable e) {
            GuaguaAppMaster.this.setDone(true);
            GuaguaAppMaster.this.getAmRMClient().stop();
        }
    }

    private class ServerHandler
    extends SimpleChannelUpstreamHandler {
        private ServerHandler() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (e instanceof ChannelStateEvent && ((ChannelStateEvent)e).getState() != ChannelState.INTEREST_OPS) {
                LOG.debug(e.toString());
            }
            super.handleUpstream(ctx, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            GuaguaIterationStatus status = GsonUtils.fromJson(e.getMessage().toString(), GuaguaIterationStatus.class);
            LOG.info("Receive RPC status:{}", (Object)status);
            Object object = LOCK;
            synchronized (object) {
                GuaguaAppMaster.this.partitionProgress.put(status.getPartition(), status);
            }
            if (status.isKillContainer()) {
                List containers;
                Object object2 = LOCK;
                synchronized (object2) {
                    containers = (List)GuaguaAppMaster.this.partitionContainerMap.get(status.getPartition());
                }
                LOG.info("containers:{}", (Object)containers);
                Container container = (Container)containers.get(containers.size() - 1);
                LOG.info("Container {} in node {} is killed because of straggler condition.", (Object)container.getId(), (Object)container.getNodeId());
                GuaguaAppMaster.this.getNmClientAsync().stopContainerAsync(container.getId(), container.getNodeId());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            e.getChannel().close();
        }
    }

    private static class MasterThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        MasterThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.warn("Error message in thread {} with error message {}, error root cause {}.", new Object[]{t, e, e.getCause()});
                }
            });
            return t;
        }
    }

    private static enum PartitionStatus {
        INIT,
        SUCCESSFUL,
        FAILED,
        RETRY;

    }
}

