/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YarnUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YarnUtils.class);
    public static final String GUAGUA_YARN_TMP = "tmp";

    private YarnUtils() {
    }

    public static Map<String, LocalResource> getLocalResourceMap(Configuration conf, ApplicationId appId) throws IOException {
        HashMap localResources = Maps.newHashMap();
        FileSystem fs = FileSystem.get((Configuration)conf);
        YarnUtils.addFileToResourceMap(localResources, fs, YarnUtils.getPathForResource(fs, conf.get("guagua.yarn.app.jar"), appId));
        try {
            YarnUtils.addFileToResourceMap(localResources, fs, YarnUtils.getPathForResource(fs, "log4j.properties", appId));
        }
        catch (FileNotFoundException e) {
            LOG.warn("log4j.properties does not exist!");
        }
        YarnUtils.addFileToResourceMap(localResources, fs, YarnUtils.getPathForResource(fs, "guagua-conf.xml", appId));
        String libs = conf.get("guagua.yarn.app.lib.jar");
        if (StringUtils.isNotEmpty((String)libs)) {
            for (String jar : Splitter.on((String)",").split((CharSequence)libs)) {
                YarnUtils.addFileToResourceMap(localResources, fs, YarnUtils.getPathForResource(fs, jar.trim(), appId));
            }
        }
        return localResources;
    }

    public static List<String> getCommand(String mainClass, String vmArgs, String programArgs, String memory) {
        ArrayList<String> commands = new ArrayList<String>(1);
        commands.add(YarnUtils.getCommandBase(mainClass, vmArgs, programArgs, memory).toString());
        LOG.info("commands:{}", commands);
        return commands;
    }

    private static StringBuilder getCommandBase(String mainClass, String vmArgs, String programArgs, String memory) {
        ArrayList<String> commands = new ArrayList<String>(8);
        commands.add("exec");
        commands.add(ApplicationConstants.Environment.JAVA_HOME.$() + File.separator + "bin" + File.separator + "java");
        commands.add("-Xms" + memory + "m");
        commands.add("-Xmx" + memory + "m");
        if (vmArgs != null) {
            commands.add(vmArgs);
        }
        commands.add("-cp .:${CLASSPATH}");
        commands.add(mainClass);
        if (programArgs != null) {
            commands.add(programArgs);
        }
        commands.add("1> <LOG_DIR>" + File.separator + "stdout");
        commands.add("2> <LOG_DIR>" + File.separator + "stderr");
        StringBuilder sb = new StringBuilder(200);
        for (String cmd : commands) {
            sb.append(cmd).append(" ");
        }
        return sb;
    }

    public static void addLocalClasspathToEnv(Map<String, String> env, Configuration conf) {
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$());
        classPathEnv.append(File.pathSeparatorChar).append("./*");
        for (String cpEntry : conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            classPathEnv.append(File.pathSeparatorChar).append(cpEntry.trim());
        }
        for (String jar : conf.getStrings("mapreduce.application.classpath", org.apache.hadoop.util.StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH))) {
            classPathEnv.append(File.pathSeparatorChar).append(jar.trim());
        }
        if (conf.getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append(File.pathSeparatorChar).append(ApplicationConstants.Environment.CLASSPATH.$());
        }
        String path = YarnUtils.getFileName(conf.get("guagua.yarn.app.jar"));
        classPathEnv.append("./").append(path).append(File.pathSeparatorChar);
        String libs = conf.get("guagua.yarn.app.lib.jar");
        if (StringUtils.isNotEmpty((String)libs)) {
            for (String jar : Splitter.on((String)",").split((CharSequence)libs)) {
                classPathEnv.append("./").append(YarnUtils.getFileName(jar.trim())).append(File.pathSeparatorChar);
            }
        }
        classPathEnv.append("./").append("log4j.properties").append(File.pathSeparatorChar);
        classPathEnv.append("./").append("guagua-conf.xml");
        env.put(ApplicationConstants.Environment.CLASSPATH.toString(), classPathEnv.toString());
    }

    private static String getFileName(String string) {
        return new Path(string).getName();
    }

    public static Path getPathForResource(FileSystem fs, String loc, ApplicationId appId) {
        return new Path(YarnUtils.getAppDirectory(fs, appId), YarnUtils.getFileName(loc));
    }

    public static Path getAppDirectory(FileSystem fs, ApplicationId appId) {
        return fs.makeQualified(new Path(new Path(File.separator + GUAGUA_YARN_TMP, "guagua"), appId.toString()));
    }

    public static void copyLocalResourcesToFs(Configuration conf, ApplicationId appId) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path appDir = YarnUtils.getAppDirectory(fs, appId);
        String appJar = conf.get("guagua.yarn.app.jar");
        YarnUtils.copyToFs(conf, appJar, new Path(appDir, YarnUtils.getFileName(appJar)).toString());
        String libs = conf.get("guagua.yarn.app.lib.jar");
        if (StringUtils.isNotEmpty((String)libs)) {
            for (String jar : Splitter.on((String)",").split((CharSequence)libs)) {
                YarnUtils.copyToFs(conf, jar, new Path(appDir, YarnUtils.getFileName(jar.trim())).toString());
            }
        }
    }

    private static void copyToFs(Configuration conf, String local, String remote) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path src = new Path(local);
        Path dst = fs.makeQualified(new Path(remote));
        fs.copyFromLocalFile(false, true, src, dst);
    }

    public static void addFileToResourceMap(Map<String, LocalResource> localResources, FileSystem fs, Path target) throws IOException {
        LocalResource resource = (LocalResource)Records.newRecord(LocalResource.class);
        FileStatus destStatus = fs.getFileStatus(target);
        resource.setResource(ConverterUtils.getYarnUrlFromURI((URI)target.toUri()));
        resource.setSize(destStatus.getLen());
        resource.setTimestamp(destStatus.getModificationTime());
        resource.setType(LocalResourceType.FILE);
        resource.setVisibility(LocalResourceVisibility.APPLICATION);
        localResources.put(target.getName(), resource);
        LOG.info("Registered file in LocalResources :{} ", (Object)target);
    }

    public static void copyLocalResourceToFs(String src, String dst, Configuration conf, ApplicationId appId) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path tempDir = YarnUtils.getAppDirectory(fs, appId);
        YarnUtils.copyToFs(conf, src, new Path(tempDir, dst).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportGuaguaConfiguration(Configuration conf, ApplicationId appId) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path hdfsConfPath = new Path(YarnUtils.getAppDirectory(fs, appId), "guagua-conf.xml");
        FSDataOutputStream fos = null;
        try {
            fos = FileSystem.get((Configuration)conf).create(hdfsConfPath, true);
            conf.writeXml((OutputStream)fos);
            fos.flush();
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
    }
}

