/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.time;

import java.util.Calendar;
import java.util.Date;
import org.encog.util.time.TimeUnit;

public class TimeSpan {
    public static final int YEARS_CENTURY = 100;
    public static final int HOURS_DAY = 24;
    public static final int MINUTES_HOUR = 60;
    public static final int SECONDS_MINUTE = 60;
    public static final int MONTHS_YEAR = 12;
    public static final int DAYS_WEEK = 7;
    public static final int YEARS_MIL = 1000;
    public static final int YEARS_SCORE = 20;
    private final Date from;
    private final Date to;

    public TimeSpan(Date from, Date to) {
        this.from = from;
        this.to = to;
    }

    public Date getFrom() {
        return this.from;
    }

    public long getSpan(TimeUnit unit) {
        switch (unit) {
            case SECONDS: {
                return this.getSpanSeconds();
            }
            case MINUTES: {
                return this.getSpanMinutes();
            }
            case HOURS: {
                return this.getSpanHours();
            }
            case DAYS: {
                return this.getSpanDays();
            }
            case WEEKS: {
                return this.getSpanWeeks();
            }
            case FORTNIGHTS: {
                return this.getSpanFortnights();
            }
            case MONTHS: {
                return this.getSpanMonths();
            }
            case YEARS: {
                return this.getSpanYears();
            }
            case SCORES: {
                return this.getSpanScores();
            }
            case CENTURIES: {
                return this.getSpanCenturies();
            }
            case MILLENNIA: {
                return this.getSpanMillennia();
            }
        }
        return 0L;
    }

    private long getSpanCenturies() {
        return this.getSpanYears() / 100L;
    }

    private long getSpanDays() {
        return this.getSpanHours() / 24L;
    }

    private long getSpanFortnights() {
        return this.getSpanWeeks() / 2L;
    }

    private long getSpanHours() {
        return this.getSpanMinutes() / 60L;
    }

    private long getSpanMillennia() {
        return this.getSpanYears() / 1000L;
    }

    private long getSpanMinutes() {
        return this.getSpanSeconds() / 60L;
    }

    private long getSpanMonths() {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(this.from);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(this.to);
        return endCal.get(2) - startCal.get(2) + (endCal.get(1) - startCal.get(1)) * 12;
    }

    private long getSpanScores() {
        return this.getSpanYears() / 20L;
    }

    private long getSpanSeconds() {
        Calendar fromCalendar = Calendar.getInstance();
        Calendar toCalendar = Calendar.getInstance();
        fromCalendar.setTime(this.from);
        toCalendar.setTime(this.to);
        return (toCalendar.getTimeInMillis() - fromCalendar.getTimeInMillis()) / 1000L;
    }

    private long getSpanWeeks() {
        return this.getSpanDays() / 7L;
    }

    private long getSpanYears() {
        return this.getSpanMonths() / 12L;
    }

    public Date getTo() {
        return this.to;
    }
}

