/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.master.MasterInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcMasterInterceptor<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
implements MasterInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(GcMasterInterceptor.class);
    private long appGCStartTime;
    private long iterGCStartTime;

    @Override
    public void preApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.appGCStartTime = this.computeGCTime();
    }

    @Override
    public void preIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.iterGCStartTime = this.computeGCTime();
        LOG.info("Application {} container {} iteration {} starts master computation.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration()});
    }

    @Override
    public void postIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} iteration {} ends with {}ms gc time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(this.computeGCTime() - this.iterGCStartTime)});
    }

    @Override
    public void postApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} ends with {}ms gc time.", new Object[]{context.getAppId(), context.getContainerId(), TimeUnit.NANOSECONDS.toMillis(this.computeGCTime() - this.appGCStartTime)});
    }

    private long computeGCTime() {
        long sum = 0L;
        List<GarbageCollectorMXBean> gcMBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : gcMBeans) {
            sum += garbageCollectorMXBean.getCollectionTime();
        }
        return sum;
    }
}

