/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import ml.shifu.guagua.io.Bytable;

public class BytableWrapper
implements Bytable {
    private byte[] bytes;
    private int currentIteration;
    private String containerId;
    private boolean isStopMessage;

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        this.currentIteration = currentIteration;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public boolean isStopMessage() {
        return this.isStopMessage;
    }

    public void setStopMessage(boolean isStopMessage) {
        this.isStopMessage = isStopMessage;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.currentIteration);
        if (this.containerId == null) {
            out.writeInt(0);
        } else {
            this.writeBytes(out, this.containerId.getBytes(Charset.forName("UTF-8")));
        }
        out.writeBoolean(this.isStopMessage);
        if (this.bytes != null) {
            out.writeInt(this.bytes.length);
            for (int i = 0; i < this.bytes.length; ++i) {
                out.writeByte(this.bytes[i]);
            }
        } else {
            out.writeInt(0);
        }
    }

    private void writeBytes(DataOutput out, byte[] bytes) throws IOException {
        out.writeInt(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            out.writeByte(bytes[i]);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        this.currentIteration = in.readInt();
        int containerIdlen = in.readInt();
        if (containerIdlen != 0) {
            byte[] containerIdbytes = new byte[containerIdlen];
            for (i = 0; i < containerIdbytes.length; ++i) {
                containerIdbytes[i] = in.readByte();
            }
            this.containerId = new String(containerIdbytes, Charset.forName("UTF-8"));
        } else {
            this.containerId = null;
        }
        this.isStopMessage = in.readBoolean();
        int bytesSize = in.readInt();
        if (bytesSize != 0) {
            this.bytes = new byte[bytesSize];
            for (i = 0; i < this.bytes.length; ++i) {
                this.bytes[i] = in.readByte();
            }
        }
    }

    public String toString() {
        return "BytableWrapper [bytes=" + Arrays.toString(this.bytes) + ", currentIteration=" + this.currentIteration + ", containerId=" + this.containerId + ", isStopMessage=" + this.isStopMessage + "]";
    }
}

