/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.unit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.GuaguaService;
import ml.shifu.guagua.InMemoryCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.master.GuaguaMasterService;
import ml.shifu.guagua.master.LocalMasterCoordinator;
import ml.shifu.guagua.worker.GuaguaWorkerService;
import ml.shifu.guagua.worker.LocalWorkerCoordinator;

public abstract class GuaguaUnitDriver<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable> {
    private static final String GUAGUA_UNIT_TEST = "Guagua Unit Test";
    private Properties props;
    private GuaguaService masterService;
    private List<GuaguaService> workerServices;
    private ExecutorService executor;
    private int iteration;
    private List<GuaguaFileSplit[]> fileSplits;

    public GuaguaUnitDriver(Properties props) {
        this.props = props;
    }

    public abstract List<GuaguaFileSplit[]> generateWorkerSplits(String var1) throws IOException;

    protected void setUp() {
        try {
            this.fileSplits = this.generateWorkerSplits(this.props.getProperty("guagua.input.dir"));
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
        this.executor = Executors.newFixedThreadPool(this.fileSplits.size() + 1, new UtDefaultThreadFactory());
        this.props.setProperty("guagua.master.system.intercepters", LocalMasterCoordinator.class.getName());
        this.props.setProperty("guagua.worker.system.intercepters", LocalWorkerCoordinator.class.getName());
        this.props.setProperty("guagua.worker.number", this.fileSplits.size() + "");
        this.iteration = Integer.parseInt(this.props.getProperty("guagua.iteration.count"));
        this.workerServices = new ArrayList<GuaguaService>();
        this.masterService = new GuaguaMasterService();
        InMemoryCoordinator coordinator = new InMemoryCoordinator(this.fileSplits.size(), this.iteration);
        this.masterService.setAppId(GUAGUA_UNIT_TEST);
        this.masterService.setContainerId("0");
        ((GuaguaMasterService)this.masterService).setCoordinator(coordinator);
        this.masterService.init(this.props);
        for (int i = 0; i < this.fileSplits.size(); ++i) {
            GuaguaWorkerService workerService = new GuaguaWorkerService();
            workerService.setAppId(GUAGUA_UNIT_TEST);
            workerService.setContainerId(i + 1 + "");
            workerService.setSplits(Arrays.asList((Object[])this.fileSplits.get(i)));
            workerService.setCoordinator(coordinator);
            workerService.init(this.props);
            this.workerServices.add(workerService);
        }
    }

    public void run() {
        this.setUp();
        this.doRun();
        this.tearDown();
    }

    protected void doRun() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                GuaguaUnitDriver.this.masterService.start();
                GuaguaUnitDriver.this.masterService.run(null);
                GuaguaUnitDriver.this.masterService.stop();
            }
        });
        for (final GuaguaService workerService : this.workerServices) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    workerService.start();
                    workerService.run(null);
                    workerService.stop();
                }
            });
        }
    }

    protected void tearDown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static class UtDefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        UtDefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
            return t;
        }
    }
}

