/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.util.ObjectSerializer;

public class JavaObjectSerializer<T>
implements ObjectSerializer<T> {
    @Override
    public byte[] serialize(T t) {
        ObjectOutputStream output = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            output = new ObjectOutputStream(bout);
            output.writeObject(t);
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public T deserialize(byte[] bytes, Class<?> clazz) {
        Object object;
        ObjectInputStream input = null;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            input = new ObjectInputStream(bin);
            object = input.readObject();
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)object;
    }
}

