/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;

public final class SizeEstimator {
    private static final long BYTE_SIZE = 1L;
    private static final long BOOLEAN_SIZE = 1L;
    private static final long CHAR_SIZE = 2L;
    private static final long SHORT_SIZE = 2L;
    private static final long INT_SIZE = 4L;
    private static final long LONG_SIZE = 8L;
    private static final long FLOAT_SIZE = 4L;
    private static final long DOUBLE_SIZE = 8L;
    private static final int ALIGN_SIZE = 8;
    private static Map<Class<?>, ClassInfo> classInfos = new ConcurrentHashMap();
    private static boolean is64bit = false;
    private static boolean isCompressedOops = false;
    private static int pointerSize = 4;
    private static int objectSize = 8;
    private static final long ARRAY_SIZE_FOR_SAMPLING = 200L;
    private static final long ARRAY_SAMPLE_SIZE = 100L;

    private static void initialize() {
        is64bit = System.getProperty("os.arch").contains("64");
        isCompressedOops = SizeEstimator.getIsCompressedOops();
        objectSize = !is64bit ? 8 : (!isCompressedOops ? 16 : 12);
        pointerSize = is64bit && !isCompressedOops ? 8 : 4;
        classInfos.clear();
    }

    private static boolean getIsCompressedOops() {
        try {
            String hotSpotMBeanName = "com.sun.management:type=HotSpotDiagnostic";
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Class<?> hotSpotMBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method getVMMethod = hotSpotMBeanClass.getDeclaredMethod("getVMOption", Class.forName("java.lang.String"));
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, hotSpotMBeanName, hotSpotMBeanClass);
            return getVMMethod.invoke(bean, "UseCompressedOops").toString().contains("true");
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static long estimate(Object obj) {
        return SizeEstimator.estimate(obj, new IdentityHashMap<Object, Object>());
    }

    private static long estimate(Object obj, IdentityHashMap<Object, Object> visited) {
        SearchState state = new SearchState(visited);
        state.enqueue(obj);
        while (!state.isFinished()) {
            SizeEstimator.visitSingleObject(state.dequeue(), state);
        }
        return state.getSize();
    }

    private static void visitSingleObject(Object obj, SearchState state) {
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            SizeEstimator.visitArray(obj, cls, state);
        } else if (!(obj instanceof ClassLoader) && !(obj instanceof Class)) {
            ClassInfo classInfo = SizeEstimator.getClassInfo(cls);
            state.setSize(state.getSize() + classInfo.shellSize);
            for (Field field : classInfo.pointerFields) {
                try {
                    state.enqueue(field.get(obj));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void visitArray(Object array, Class<?> cls, SearchState state) {
        int length = Array.getLength(array);
        Class<?> elementClass = cls.getComponentType();
        long arrSize = SizeEstimator.alignSize((long)objectSize + 4L);
        if (elementClass.isPrimitive()) {
            SearchState searchState = state;
            searchState.size = searchState.size + (arrSize += SizeEstimator.alignSize((long)length * SizeEstimator.primitiveSize(elementClass)));
        } else {
            SearchState searchState = state;
            searchState.size = searchState.size + (arrSize += SizeEstimator.alignSize(length * SizeEstimator.pointerSize));
            if ((long)length <= 200L) {
                for (int i = 0; i < length; ++i) {
                    state.enqueue(Array.get(array, i));
                }
            } else {
                double size = 0.0;
                Random rand = new Random(42L);
                HashSet<Integer> drawn = new HashSet<Integer>(100);
                int i = 0;
                while ((long)i < 100L) {
                    int index = 0;
                    while (drawn.contains(index = rand.nextInt(length))) {
                    }
                    drawn.add(index);
                    Object elem = Array.get(array, index);
                    size += (double)SizeEstimator.estimate(elem, state.visited);
                    ++i;
                }
                SearchState searchState2 = state;
                searchState2.size = searchState2.size + Double.valueOf((double)length / 100.0 * size).longValue();
            }
        }
    }

    private static long primitiveSize(Class<?> cls) {
        if (cls == Byte.TYPE) {
            return 1L;
        }
        if (cls == Boolean.TYPE) {
            return 1L;
        }
        if (cls == Character.TYPE) {
            return 2L;
        }
        if (cls == Short.TYPE) {
            return 2L;
        }
        if (cls == Integer.TYPE) {
            return 4L;
        }
        if (cls == Long.TYPE) {
            return 8L;
        }
        if (cls == Float.TYPE) {
            return 4L;
        }
        if (cls == Double.TYPE) {
            return 8L;
        }
        throw new IllegalArgumentException("Non-primitive class " + cls + " passed to primitiveSize()");
    }

    private static ClassInfo getClassInfo(Class<?> cls) {
        if (cls == Object.class) {
            ClassInfo info = new ClassInfo(8L, new ArrayList<Field>());
            classInfos.put(cls, info);
            return info;
        }
        ClassInfo info = classInfos.get(cls);
        if (info != null) {
            return info;
        }
        Class<?> superClass = cls.getSuperclass();
        ClassInfo parent = SizeEstimator.getClassInfo(superClass);
        long shellSize = parent.shellSize;
        List pointerFields = parent.pointerFields;
        for (Field field : cls.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Class<?> fieldClass = field.getType();
            if (fieldClass.isPrimitive()) {
                shellSize += SizeEstimator.primitiveSize(fieldClass);
                continue;
            }
            field.setAccessible(true);
            shellSize += (long)pointerSize;
            pointerFields.add(0, field);
        }
        shellSize = SizeEstimator.alignSize(shellSize);
        ClassInfo newInfo = new ClassInfo(shellSize, pointerFields);
        classInfos.put(cls, newInfo);
        return newInfo;
    }

    private static long alignSize(long size) {
        long rem = size % 8L;
        if (rem == 0L) {
            return size;
        }
        return size + 8L - rem;
    }

    static {
        SizeEstimator.initialize();
    }

    private static class SearchState {
        private IdentityHashMap<Object, Object> visited;
        List<Object> stack = new ArrayList<Object>();
        private long size = 0L;

        public SearchState(IdentityHashMap<Object, Object> visited) {
            this.visited = visited;
        }

        public void enqueue(Object obj) {
            if (obj != null && !this.visited.containsKey(obj)) {
                this.visited.put(obj, null);
                this.stack.add(obj);
            }
        }

        public boolean isFinished() {
            return this.stack.isEmpty();
        }

        public Object dequeue() {
            Object elem = this.stack.get(this.stack.size() - 1);
            this.stack.remove(this.stack.size() - 1);
            return elem;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }
    }

    private static class ClassInfo {
        private final long shellSize;
        private final List<Field> pointerFields;

        public ClassInfo(long shellSize, List<Field> pointerFields) {
            this.shellSize = shellSize;
            this.pointerFields = pointerFields;
        }
    }
}

