/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.example.kmeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ml.shifu.guagua.io.HaltBytable;

public class KMeansMasterParams
extends HaltBytable {
    private int k;
    private int c;
    private List<double[]> pointList;

    public void doWrite(DataOutput out) throws IOException {
        this.validate();
        out.writeInt(this.k);
        out.writeInt(this.c);
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.c; ++j) {
                out.writeDouble(this.pointList.get(i)[j]);
            }
        }
    }

    private void validate() {
        this.validateK();
        this.validateC();
        if (this.k != this.pointList.size()) {
            throw new IllegalArgumentException("In-consistent sum list.");
        }
    }

    public void doReadFields(DataInput in) throws IOException {
        this.k = in.readInt();
        this.validateK();
        this.c = in.readInt();
        this.validateC();
        this.pointList = new LinkedList<double[]>();
        for (int i = 0; i < this.k; ++i) {
            double[] units = new double[this.c];
            for (int j = 0; j < this.c; ++j) {
                units[j] = in.readDouble();
            }
            this.pointList.add(units);
        }
    }

    private void validateK() {
        if (this.k <= 0) {
            throw new IllegalArgumentException("'k' should be a positive number.");
        }
    }

    private void validateC() {
        if (this.c <= 0) {
            throw new IllegalArgumentException("'c' (cloumn number) should be a positive number.");
        }
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getC() {
        return this.c;
    }

    public void setC(int c) {
        this.c = c;
    }

    public List<double[]> getPointList() {
        return this.pointList;
    }

    public void setPointList(List<double[]> pointList) {
        this.pointList = pointList;
    }
}

